/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.belgie.tricky_trials.core.TTTagsRegistry;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class InfestedSkeletonEntity
extends AbstractSkeleton {
    private static final int HARD_ATTACK_INTERVAL = 50;
    private static final int NORMAL_ATTACK_INTERVAL = 70;

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractSkeleton.createAttributes().add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.MAX_HEALTH, 35.0);
    }

    public InfestedSkeletonEntity(EntityType<? extends InfestedSkeletonEntity> p_333629_, Level p_333576_) {
        super(p_333629_, p_333576_);
    }

    public boolean canAttackType(EntityType<?> p_21399_) {
        return !p_21399_.is(TTTagsRegistry.TRICKY_TRIALS_MOBS);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TTSoundRegistry.BRISTLE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_331504_) {
        return (SoundEvent)TTSoundRegistry.BRISTLE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.BRISTLE_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)TTSoundRegistry.BRISTLE_STEP.get();
    }

    public void die(DamageSource p_21014_) {
        int $$4 = Mth.randomBetweenInclusive((RandomSource)this.random, (int)1, (int)2);
        for (int $$5 = 0; $$5 < $$4; ++$$5) {
            this.spawnSilverfish(this.level(), (LivingEntity)this, this.getX(), this.getY() + (double)this.getBbHeight() / 2.0, this.getZ());
        }
        super.die(p_21014_);
    }

    private void spawnSilverfish(Level p_332452_, LivingEntity p_327972_, double p_334243_, double p_334439_, double p_333358_) {
        Silverfish $$5 = (Silverfish)EntityType.SILVERFISH.create(p_332452_, EntitySpawnReason.TRIGGERED);
        if ($$5 != null) {
            RandomSource $$6 = p_327972_.getRandom();
            float $$7 = 1.5707964f;
            float $$8 = Mth.randomBetween((RandomSource)$$6, (float)-1.5707964f, (float)1.5707964f);
            Vector3f $$9 = p_327972_.getLookAngle().toVector3f().mul(0.3f).mul(1.0f, 1.5f, 1.0f).rotateY($$8);
            $$5.moveTo(p_334243_, p_334439_, p_333358_, p_332452_.getRandom().nextFloat() * 360.0f, 0.0f);
            $$5.setDeltaMovement(new Vec3($$9));
            p_332452_.addFreshEntity((Entity)$$5);
            $$5.playSound(SoundEvents.SILVERFISH_HURT);
        }
    }

    protected AbstractArrow getArrow(ItemStack p_333556_, float p_332689_, @Nullable ItemStack p_343334_) {
        AbstractArrow abstractarrow = super.getArrow(p_333556_, p_332689_, p_343334_);
        if (abstractarrow instanceof Arrow) {
            Arrow arrow = (Arrow)abstractarrow;
            arrow.addEffect(new MobEffectInstance(MobEffects.INFESTED, 100));
        }
        return abstractarrow;
    }

    protected int getHardAttackInterval() {
        return 50;
    }

    protected int getAttackInterval() {
        return 70;
    }
}

