/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import java.util.EnumSet;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public abstract class MagicBossEntity
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_SPELL_CASTING_ID = SynchedEntityData.defineId(MagicBossEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected int spellCastingTickCount;
    private IllagerSpell currentSpell = IllagerSpell.NONE;

    protected MagicBossEntity(EntityType<? extends MagicBossEntity> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335149_) {
        super.defineSynchedData(p_335149_);
        p_335149_.define(DATA_SPELL_CASTING_ID, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag p_33732_) {
        super.readAdditionalSaveData(p_33732_);
        this.spellCastingTickCount = p_33732_.getInt("SpellTicks");
    }

    public void addAdditionalSaveData(CompoundTag p_33734_) {
        super.addAdditionalSaveData(p_33734_);
        p_33734_.putInt("SpellTicks", this.spellCastingTickCount);
    }

    public boolean isCastingSpell() {
        if (this.level().isClientSide) {
            return (Byte)this.entityData.get(DATA_SPELL_CASTING_ID) > 0;
        }
        return this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(IllagerSpell p_33728_) {
        this.currentSpell = p_33728_;
        this.entityData.set(DATA_SPELL_CASTING_ID, (Object)((byte)p_33728_.id));
    }

    protected IllagerSpell getCurrentSpell() {
        return !this.level().isClientSide ? this.currentSpell : IllagerSpell.byId(((Byte)this.entityData.get(DATA_SPELL_CASTING_ID)).byteValue());
    }

    protected void customServerAiStep(ServerLevel p_361697_) {
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.isCastingSpell()) {
            IllagerSpell $$0 = this.getCurrentSpell();
            float $$1 = (float)$$0.spellColor[0];
            float $$2 = (float)$$0.spellColor[1];
            float $$3 = (float)$$0.spellColor[2];
            float $$4 = this.yBodyRot * ((float)Math.PI / 180) + Mth.cos((float)((float)this.tickCount * 0.6662f)) * 0.25f;
            float $$5 = Mth.cos((float)$$4);
            float $$6 = Mth.sin((float)$$4);
            double $$7 = 0.6 * (double)this.getScale();
            double d = 1.8 * (double)this.getScale();
        }
    }

    protected int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    protected abstract SoundEvent getCastingSoundEvent();

    protected static enum IllagerSpell {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2);

        private static final IntFunction<IllagerSpell> BY_ID;
        final int id;
        final double[] spellColor;

        private IllagerSpell(int p_33754_, double p_33755_, double p_33756_, double p_33757_) {
            this.id = p_33754_;
            this.spellColor = new double[]{p_33755_, p_33756_, p_33757_};
        }

        public static IllagerSpell byId(int p_33759_) {
            return BY_ID.apply(p_33759_);
        }

        static {
            BY_ID = ByIdMap.continuous(p_263091_ -> p_263091_.id, (Object[])IllagerSpell.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    protected class SpellcasterCastingSpellGoal
    extends Goal {
        public SpellcasterCastingSpellGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return MagicBossEntity.this.getSpellCastingTime() > 0;
        }

        public void start() {
            super.start();
            MagicBossEntity.this.navigation.stop();
        }

        public void stop() {
            super.stop();
            MagicBossEntity.this.setIsCastingSpell(IllagerSpell.NONE);
        }

        public void tick() {
            if (MagicBossEntity.this.getTarget() != null) {
                MagicBossEntity.this.getLookControl().setLookAt((Entity)MagicBossEntity.this.getTarget(), (float)MagicBossEntity.this.getMaxHeadYRot(), (float)MagicBossEntity.this.getMaxHeadXRot());
            }
        }
    }

    protected abstract class SpellcasterUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected SpellcasterUseSpellGoal() {
        }

        public boolean canUse() {
            LivingEntity $$0 = MagicBossEntity.this.getTarget();
            if ($$0 != null && $$0.isAlive()) {
                if (MagicBossEntity.this.isCastingSpell()) {
                    return false;
                }
                return MagicBossEntity.this.tickCount >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity $$0 = MagicBossEntity.this.getTarget();
            return $$0 != null && $$0.isAlive() && this.attackWarmupDelay > 0;
        }

        public void start() {
            this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
            MagicBossEntity.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = MagicBossEntity.this.tickCount + this.getCastingInterval();
            SoundEvent $$0 = this.getSpellPrepareSound();
            if ($$0 != null) {
                MagicBossEntity.this.playSound($$0, 1.0f, 1.0f);
            }
            MagicBossEntity.this.setIsCastingSpell(this.getSpell());
        }

        public void tick() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract IllagerSpell getSpell();
    }
}

