/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.entity.StealthEntity;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class MoolinBeastEntity
extends Monster {
    public AnimationState idle = new AnimationState();
    public AnimationState walk = new AnimationState();
    public AnimationState attack = new AnimationState();
    private static final ResourceLocation MODIFIER_ID = ResourceLocation.withDefaultNamespace((String)"buff");
    private static final AttributeModifier STEALTH_MODIFIER = new AttributeModifier(MODIFIER_ID, 0.2, AttributeModifier.Operation.ADD_VALUE);
    private final TargetingConditions vexCountTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();

    public MoolinBeastEntity(EntityType<? extends MoolinBeastEntity> p_34074_, Level p_34075_) {
        super(p_34074_, p_34075_);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 8.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 8.0f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{MoolinBeastEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TTSoundRegistry.REDSTONE_BEAST_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.REDSTONE_BEAST_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34103_) {
        return (SoundEvent)TTSoundRegistry.REDSTONE_BEAST_HURT.get();
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public float getVoicePitch() {
        return -2.7f;
    }

    public void tick() {
        if (this.level().isClientSide()) {
            this.idle.animateWhen(!this.walkAnimation.isMoving(), this.tickCount);
        }
        List stealth = this.level().getEntitiesOfClass(StealthEntity.class, this.getBoundingBox().inflate(3.0));
        if (this.level().getRandom().nextInt(1000) == 0) {
            for (StealthEntity stealth1 : stealth) {
                stealth1.setRedstoneCount(stealth1.getRedstoneCount() + 1);
            }
        }
        super.tick();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected int decreaseAirSupply(int p_28882_) {
        return p_28882_;
    }

    public boolean canSpawnSprintParticle() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0;
    }

    private float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    public boolean doHurtTarget(ServerLevel sl, Entity p_28837_) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        float $$1 = this.getAttackDamage();
        float $$2 = (int)$$1 > 0 ? $$1 / 2.0f + (float)this.random.nextInt((int)$$1) : $$1;
        DamageSource $$3 = this.damageSources().mobAttack((LivingEntity)this);
        boolean $$4 = p_28837_.hurtServer(sl, $$3, $$2);
        if ($$4) {
            double var10000;
            if (p_28837_ instanceof LivingEntity) {
                LivingEntity $$5 = (LivingEntity)p_28837_;
                var10000 = $$5.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            } else {
                var10000 = 0.0;
            }
            double $$6 = var10000;
            double $$7 = Math.max(0.0, 1.0 - $$6);
            p_28837_.setDeltaMovement(p_28837_.getDeltaMovement().add(0.0, (double)0.4f * $$7, 0.0));
            Level var11 = this.level();
            if (var11 instanceof ServerLevel) {
                ServerLevel $$8 = (ServerLevel)var11;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)$$8, (Entity)p_28837_, (DamageSource)$$3);
            }
        }
        this.playSound((SoundEvent)TTSoundRegistry.REDSTONE_BEAST_ATTACK.get(), 1.0f, 1.0f);
        return $$4;
    }

    public void handleEntityEvent(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attack.start(this.tickCount);
            this.idle.stop();
            this.walk.stop();
        } else {
            super.handleEntityEvent(p_28844_);
        }
    }

    protected void playStepSound(BlockPos p_28864_, BlockState p_28865_) {
        this.playSound((SoundEvent)TTSoundRegistry.REDSTONE_BEAST_STEP.get(), 1.0f, 1.0f);
    }

    public void die(DamageSource p_28846_) {
        super.die(p_28846_);
    }

    public boolean checkSpawnObstruction(LevelReader p_28853_) {
        BlockPos $$1 = this.blockPosition();
        BlockPos $$2 = $$1.below();
        BlockState $$3 = p_28853_.getBlockState($$2);
        if (!$$3.entityCanStandOn((BlockGetter)p_28853_, $$2, (Entity)this)) {
            return false;
        }
        for (int $$4 = 1; $$4 < 3; ++$$4) {
            BlockState $$6;
            BlockPos $$5 = $$1.above($$4);
            if (NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)p_28853_, (BlockPos)$$5, (BlockState)($$6 = p_28853_.getBlockState($$5)), (FluidState)$$6.getFluidState(), (EntityType)EntityType.IRON_GOLEM)) continue;
            return false;
        }
        return NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)p_28853_, (BlockPos)$$1, (BlockState)p_28853_.getBlockState($$1), (FluidState)Fluids.EMPTY.defaultFluidState(), (EntityType)EntityType.IRON_GOLEM) && p_28853_.isUnobstructed((Entity)this);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.875f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }
}

