/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.entity.AI.MoolinFollowOwnerGoal;
import com.belgie.tricky_trials.common.items.TitaniumBatItem;
import com.belgie.tricky_trials.core.TTItemRegistry;
import com.belgie.tricky_trials.core.TTMobEffects;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.belgie.tricky_trials.core.TTTagsRegistry;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.EventHooks;

public class MoolinEntity
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(MoolinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final Predicate<Entity> PREY_SELECTOR = p_341422_ -> {
        EntityType entitytype = p_341422_.getType();
        return entitytype == EntityType.SHEEP || entitytype == EntityType.COW || entitytype == EntityType.CHICKEN;
    };
    private static final float START_HEALTH = 16.0f;
    private static final float TAME_HEALTH = 25.0f;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;

    public MoolinEntity(EntityType<? extends MoolinEntity> p_30369_, Level p_30370_) {
        super(p_30369_, p_30370_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(3, new WolfAvoidEntityGoal<Ocelot>(this, Ocelot.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new MoolinFollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (arg_0, arg_1) -> ((MoolinEntity)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, (p_359163_, p_359164_) -> PREY_SELECTOR.test((Entity)p_359163_)));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public boolean killedEntity(ServerLevel p_219160_, LivingEntity p_219161_) {
        boolean flag = super.killedEntity(p_219160_, p_219161_);
        if (p_219161_ instanceof LivingEntity) {
            if (this.random.nextBoolean()) {
                return flag;
            }
            LivingEntity owner = this.getOwner();
            if (owner != null && owner instanceof Player) {
                Player player = (Player)owner;
                if ((double)player.level().random.nextInt() < 0.5) {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 600, 0));
                }
                if ((double)player.level().random.nextInt() < 0.4) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
                }
                if ((double)player.level().random.nextInt() < 0.2) {
                    player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 600, 1));
                }
                if ((double)player.level().random.nextInt() < 0.3) {
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 1));
                }
            }
        }
        return flag;
    }

    public boolean doHurtTarget(ServerLevel sl, Entity p_28837_) {
        DamageSource $$3 = this.damageSources().mobAttack((LivingEntity)this);
        boolean $$4 = p_28837_.hurtServer(sl, $$3, (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
        if ($$4 && this.getItemInHand(InteractionHand.MAIN_HAND).is(TTItemRegistry.TITANIUM_BAT.get())) {
            TitaniumBatItem.strongKnockback(2, (LivingEntity)this, p_28837_);
        }
        return $$4;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_332186_) {
        super.defineSynchedData(p_332186_);
        p_332186_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    protected void playStepSound(BlockPos p_30415_, BlockState p_30416_) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    public void addAdditionalSaveData(CompoundTag p_30418_) {
        super.addAdditionalSaveData(p_30418_);
        this.addPersistentAngerSaveData(p_30418_);
    }

    public void readAdditionalSaveData(CompoundTag p_30402_) {
        super.readAdditionalSaveData(p_30402_);
        this.readPersistentAngerSaveData(this.level(), p_30402_);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_333916_, DifficultyInstance p_329109_, EntitySpawnReason p_334609_, @Nullable SpawnGroupData p_328496_) {
        Panda chicken1;
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)TTItemRegistry.TITANIUM_BAT.get()));
        RandomSource randomsource = p_333916_.getRandom();
        if ((double)randomsource.nextFloat() < 0.1 && (chicken1 = (Panda)EntityType.PANDA.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
            chicken1.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            chicken1.finalizeSpawn(p_333916_, p_329109_, EntitySpawnReason.JOCKEY, (SpawnGroupData)null);
            if (randomsource.nextInt(423) == 0) {
                chicken1.setMainGene(Panda.Gene.BROWN);
            } else {
                chicken1.setMainGene(Panda.Gene.AGGRESSIVE);
            }
            this.startRiding((Entity)chicken1);
            p_333916_.addFreshEntity((Entity)chicken1);
        }
        return super.finalizeSpawn(p_333916_, p_329109_, p_334609_, p_328496_);
    }

    protected SoundEvent getAmbientSound() {
        if (this.isAngry()) {
            return (SoundEvent)TTSoundRegistry.MOOLIN_ANGRY.get();
        }
        if (this.random.nextInt(3) != 0) {
            return (SoundEvent)TTSoundRegistry.MOOLIN_AMBIENT.get();
        }
        return (SoundEvent)TTSoundRegistry.MOOLIN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_30424_) {
        return this.canArmorAbsorb(p_30424_) ? SoundEvents.WOLF_ARMOR_DAMAGE : (SoundEvent)TTSoundRegistry.MOOLIN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.MOOLIN_DEATH.get();
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public boolean hurtServer(ServerLevel p_361743_, DamageSource p_361865_, float p_365677_) {
        boolean flag = super.hurtServer(p_361743_, p_361865_, p_365677_);
        if (this.isInvulnerableTo(p_361743_, p_361865_)) {
            return false;
        }
        return super.hurtServer(p_361743_, p_361865_, p_365677_);
    }

    public boolean canBeAffected(MobEffectInstance p_34192_) {
        return p_34192_.is(TTMobEffects.STUNNED) ? false : super.canBeAffected(p_34192_);
    }

    public boolean canUseSlot(EquipmentSlot p_343110_) {
        return true;
    }

    protected void actuallyHurt(ServerLevel p_364204_, DamageSource p_328294_, float p_327706_) {
        if (!this.canArmorAbsorb(p_328294_)) {
            super.actuallyHurt(p_364204_, p_328294_, p_327706_);
        } else {
            ItemStack itemstack = this.getBodyArmorItem();
            int i = itemstack.getDamageValue();
            int j = itemstack.getMaxDamage();
            itemstack.hurtAndBreak(Mth.ceil((float)p_327706_), (LivingEntity)this, EquipmentSlot.BODY);
            if (Crackiness.WOLF_ARMOR.byDamage(i, j) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
                this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
                Level var7 = this.level();
                if (var7 instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)var7;
                    serverlevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, TTItemRegistry.TITANIUM_INGOT.get().getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
                }
            }
        }
    }

    private boolean canArmorAbsorb(DamageSource p_335120_) {
        return this.hasArmor() && !p_335120_.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(25.0);
            this.setHealth(25.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(16.0);
        }
    }

    protected void hurtArmor(DamageSource p_331879_, float p_331430_) {
        this.doHurtEquipment(p_331879_, p_331430_, new EquipmentSlot[]{EquipmentSlot.BODY});
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        if (!this.level().isClientSide || this.isBaby() && this.isFood(itemstack)) {
            if (this.isTame()) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    itemstack.consume(1, (LivingEntity)p_30412_);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(2.0f * f);
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.is(TTItemRegistry.MOOLIN_ARMOR.get()) && this.isOwnedBy((LivingEntity)p_30412_) && this.getBodyArmorItem().isEmpty() && !this.isBaby()) {
                    this.setBodyArmorItem(itemstack.copyWithCount(1));
                    itemstack.consume(1, (LivingEntity)p_30412_);
                    return InteractionResult.SUCCESS;
                }
                if (!itemstack.canPerformAction(ItemAbilities.SHEARS_REMOVE_ARMOR) || !this.isOwnedBy((LivingEntity)p_30412_) || !this.hasArmor() || EnchantmentHelper.has((ItemStack)this.getBodyArmorItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !p_30412_.isCreative()) {
                    if (itemstack.is(TTItemRegistry.TITANIUM_INGOT.get()) && this.hasArmor() && this.isOwnedBy((LivingEntity)p_30412_) && this.getBodyArmorItem().isDamaged()) {
                        itemstack.shrink(1);
                        this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                        ItemStack itemstack2 = this.getBodyArmorItem();
                        int i = (int)((float)itemstack2.getMaxDamage() * 0.125f);
                        itemstack2.setDamageValue(Math.max(0, itemstack2.getDamageValue() - i));
                        return InteractionResult.SUCCESS;
                    }
                    InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
                    if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                        this.jumping = false;
                        this.navigation.stop();
                        this.setTarget(null);
                        return InteractionResult.SUCCESS;
                    }
                    return interactionresult;
                }
                return InteractionResult.PASS;
            }
            if (itemstack.is(TTItemRegistry.BAMBOO_STEW.get()) && !this.isAngry()) {
                itemstack.consume(1, (LivingEntity)p_30412_);
                this.tryToTame(p_30412_);
                return InteractionResult.SUCCESS;
            }
            return super.mobInteract(p_30412_, p_30413_);
        }
        boolean flag = this.isOwnedBy((LivingEntity)p_30412_) || this.isTame() || itemstack.is(TTItemRegistry.BAMBOO_STEW.get()) && !this.isTame() && !this.isAngry();
        return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    private void tryToTame(Player p_336244_) {
        if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)p_336244_)) {
            this.tameMoo(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public void tameMoo(Player p_21829_) {
        this.setTame(true, true);
        this.setOwnerUUID(p_21829_.getUUID());
    }

    public boolean isFood(ItemStack p_30440_) {
        return p_30440_.is(TTTagsRegistry.MOOLIN_FOOD);
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public boolean hasArmor() {
        return this.getBodyArmorItem().is(TTItemRegistry.MOOLIN_ARMOR.get());
    }

    @Nullable
    public MoolinEntity getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        return null;
    }

    public boolean canMate(Animal p_30392_) {
        return false;
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper || p_30389_ instanceof Ghast || p_30389_ instanceof ArmorStand)) {
            if (!(p_30389_ instanceof MoolinEntity)) {
                TamableAnimal tamableanimal;
                AbstractHorse abstracthorse;
                if (p_30389_ instanceof Player) {
                    Player player1;
                    Player player = (Player)p_30389_;
                    if (p_30390_ instanceof Player && !(player1 = (Player)p_30390_).canHarmPlayer(player)) {
                        return false;
                    }
                }
                if (p_30389_ instanceof AbstractHorse && (abstracthorse = (AbstractHorse)p_30389_).isTamed()) {
                    return false;
                }
                return !(p_30389_ instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)p_30389_).isTame();
            }
            MoolinEntity wolf = (MoolinEntity)p_30389_;
            return !wolf.isTame() || wolf.getOwner() != p_30390_;
        }
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    public static boolean checkMoolinSpawnRules(EntityType<MoolinEntity> p_218292_, LevelAccessor p_218293_, EntitySpawnReason p_218294_, BlockPos p_218295_, RandomSource p_218296_) {
        return p_218293_.getBlockState(p_218295_.below()).is(Blocks.GRASS_BLOCK) && MoolinEntity.isBrightEnoughToSpawn((BlockAndTintGetter)p_218293_, (BlockPos)p_218295_);
    }

    class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final MoolinEntity wolf;

        public WolfAvoidEntityGoal(MoolinEntity p_30454_, Class<T> p_30455_, float p_30456_, double p_30457_, double p_30458_) {
            super((PathfinderMob)p_30454_, p_30455_, p_30456_, p_30457_, p_30458_);
            this.wolf = p_30454_;
        }

        public boolean canUse() {
            return super.canUse() && this.toAvoid instanceof Ocelot ? !this.wolf.isTame() && this.avoidLlama((Ocelot)this.toAvoid) : false;
        }

        private boolean avoidLlama(Ocelot p_30461_) {
            return true;
        }

        public void start() {
            MoolinEntity.this.setTarget(null);
            super.start();
        }

        public void tick() {
            MoolinEntity.this.setTarget(null);
            super.tick();
        }
    }
}

