/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.blocks.RedstoneInfestedBlock;
import com.belgie.tricky_trials.common.entity.MoolinBeastEntity;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class StealthEntity
extends Monster {
    private static final EntityDataAccessor<Integer> ID_REDSTONE_ORE_COUNT = SynchedEntityData.defineId(StealthEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ID_HAS_REDSTONE = SynchedEntityData.defineId(StealthEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ID_HAS_DEEPSLATE_REDSTONE = SynchedEntityData.defineId(StealthEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final TargetingConditions vexCountTargeting = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight().ignoreInvisibilityTesting();

    public StealthEntity(EntityType<? extends StealthEntity> p_33523_, Level p_33524_) {
        super(p_33523_, p_33524_);
    }

    public int getRedstoneCount() {
        return (Integer)this.entityData.get(ID_REDSTONE_ORE_COUNT);
    }

    public void setRedstoneCount(int p_33594_) {
        int i = Mth.clamp((int)p_33594_, (int)0, (int)64);
        this.entityData.set(ID_REDSTONE_ORE_COUNT, (Object)i);
    }

    public boolean getHasRedstone() {
        return (Boolean)this.entityData.get(ID_HAS_REDSTONE);
    }

    public void setHasRedstone(boolean p_33594_) {
        this.entityData.set(ID_HAS_REDSTONE, (Object)p_33594_);
    }

    public boolean getHasDeepslateRedstone() {
        return (Boolean)this.entityData.get(ID_HAS_DEEPSLATE_REDSTONE);
    }

    public void setHasDeepslateRedstone(boolean p_33594_) {
        this.entityData.set(ID_HAS_DEEPSLATE_REDSTONE, (Object)p_33594_);
    }

    protected void dropCustomDeathLoot(ServerLevel p_345102_, DamageSource p_21385_, boolean p_21387_) {
        if (p_21385_.is(DamageTypeTags.IS_PLAYER_ATTACK)) {
            this.spawnAtLocation(p_345102_, new ItemStack((ItemLike)Items.REDSTONE, this.getRedstoneCount()));
        }
        super.dropCustomDeathLoot(p_345102_, p_21385_, p_21387_);
    }

    public void addAdditionalSaveData(CompoundTag p_33619_) {
        super.addAdditionalSaveData(p_33619_);
        p_33619_.putInt("RedstoneCount", this.getRedstoneCount());
        p_33619_.putBoolean("HasRedstone", this.getHasRedstone());
        p_33619_.putBoolean("HasDeepslateRedstone", this.getHasDeepslateRedstone());
    }

    public void readAdditionalSaveData(CompoundTag p_33607_) {
        this.setRedstoneCount(p_33607_.getInt("RedstoneCount"));
        this.setHasRedstone(p_33607_.getBoolean("HasRedstone"));
        this.setHasDeepslateRedstone(p_33607_.getBoolean("HasDeepslateRedstone"));
        super.readAdditionalSaveData(p_33607_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new TakeRedstoneBlockGoal(this));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TTSoundRegistry.STEALTH_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_33549_) {
        return (SoundEvent)TTSoundRegistry.STEALTH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.STEALTH_DEATH.get();
    }

    public void aiStep() {
        List stealth;
        if (this.level().isClientSide && !(stealth = this.level().getEntitiesOfClass(MoolinBeastEntity.class, this.getBoundingBox().inflate(8.0))).isEmpty()) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)DustParticleOptions.REDSTONE, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        super.aiStep();
    }

    public boolean hurtServer(ServerLevel sl, DamageSource p_33527_, float p_33528_) {
        List stealth = this.level().getEntitiesOfClass(MoolinBeastEntity.class, this.getBoundingBox().inflate(8.0));
        if (!stealth.isEmpty()) {
            for (MoolinBeastEntity beast : stealth) {
                beast.addEffect(new MobEffectInstance(MobEffects.GLOWING, 10, 0));
            }
            return false;
        }
        return super.hurtServer(sl, p_33527_, p_33528_);
    }

    public void setYBodyRot(float p_33553_) {
        this.setYRot(p_33553_);
        super.setYBodyRot(p_33553_);
    }

    public float getWalkTargetValue(BlockPos p_33530_, LevelReader p_33531_) {
        return RedstoneInfestedBlock.isCompatibleHostBlock(p_33531_.getBlockState(p_33530_.below())) ? 10.0f : super.getWalkTargetValue(p_33530_, p_33531_);
    }

    public static boolean checkSilverfishSpawnRules(EntityType<StealthEntity> p_219077_, LevelAccessor p_219078_, EntitySpawnReason p_219079_, BlockPos p_219080_, RandomSource p_219081_) {
        if (StealthEntity.checkAnyLightMonsterSpawnRules(p_219077_, (LevelAccessor)p_219078_, (EntitySpawnReason)p_219079_, (BlockPos)p_219080_, (RandomSource)p_219081_)) {
            Player player = p_219078_.getNearestPlayer((double)p_219080_.getX() + 0.5, (double)p_219080_.getY() + 0.5, (double)p_219080_.getZ() + 0.5, 5.0, true);
            return player == null;
        }
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335838_) {
        super.defineSynchedData(p_335838_);
        p_335838_.define(ID_REDSTONE_ORE_COUNT, (Object)0);
        p_335838_.define(ID_HAS_REDSTONE, (Object)false);
        p_335838_.define(ID_HAS_DEEPSLATE_REDSTONE, (Object)false);
    }

    static class TakeRedstoneBlockGoal
    extends Goal {
        private final StealthEntity enderman;

        public TakeRedstoneBlockGoal(StealthEntity p_32585_) {
            this.enderman = p_32585_;
        }

        public boolean canUse() {
            if (!this.enderman.getHasRedstone() && this.enderman.getRedstoneCount() < 64) {
                return false;
            }
            return EventHooks.canEntityGrief((ServerLevel)((ServerLevel)this.enderman.level()), (Entity)this.enderman);
        }

        public void tick() {
            RandomSource randomsource = this.enderman.getRandom();
            Level level = this.enderman.level();
            int i = Mth.floor((double)(this.enderman.getX() - 2.0 + randomsource.nextDouble() * 4.0));
            int j = Mth.floor((double)(this.enderman.getY() + randomsource.nextDouble() * 3.0));
            int k = Mth.floor((double)(this.enderman.getZ() - 2.0 + randomsource.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = level.getBlockState(blockpos);
            Vec3 vec3 = new Vec3((double)this.enderman.getBlockX() + 0.5, (double)j + 0.5, (double)this.enderman.getBlockZ() + 0.5);
            Vec3 vec31 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockHitResult blockhitresult = level.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.enderman));
            boolean flag = blockhitresult.getBlockPos().equals((Object)blockpos);
            if (blockstate.is(Blocks.DEEPSLATE_REDSTONE_ORE) && flag) {
                level.removeBlock(blockpos, false);
                level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, blockpos, GameEvent.Context.of((Entity)this.enderman, (BlockState)blockstate));
                this.enderman.setRedstoneCount(this.enderman.getRedstoneCount() + this.enderman.level().getRandom().nextIntBetweenInclusive(1, 6));
                this.enderman.level().playSound((Player)null, blockpos, SoundEvents.DEEPSLATE_BREAK, SoundSource.HOSTILE, 1.0f, 1.0f);
                TakeRedstoneBlockGoal.spawnParticles(this.enderman.level(), blockpos);
            }
        }

        private static void spawnParticles(Level p_55455_, BlockPos p_55456_) {
            double d0 = 0.5625;
            RandomSource randomsource = p_55455_.random;
            for (Direction direction : Direction.values()) {
                BlockPos blockpos = p_55456_.relative(direction);
                if (p_55455_.getBlockState(blockpos).isSolidRender()) continue;
                Direction.Axis direction$axis = direction.getAxis();
                double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)randomsource.nextFloat();
                double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)randomsource.nextFloat();
                double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)randomsource.nextFloat();
                p_55455_.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE_REDSTONE_ORE.defaultBlockState()), (double)p_55456_.getX() + d1, (double)p_55456_.getY() + d2, (double)p_55456_.getZ() + d3, 0.0, 0.0, 0.0);
            }
        }
    }

    static class SilverfishWakeUpFriendsGoal
    extends Goal {
        private final StealthEntity silverfish;
        private int lookForFriends;

        public SilverfishWakeUpFriendsGoal(StealthEntity p_33565_) {
            this.silverfish = p_33565_;
        }

        public void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = this.adjustedTickDelay(20);
            }
        }

        public boolean canUse() {
            return this.lookForFriends > 0;
        }

        public void tick() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                Level level = this.silverfish.level();
                RandomSource randomsource = this.silverfish.getRandom();
                BlockPos blockpos = this.silverfish.blockPosition();
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            Level level2;
                            BlockPos blockpos1 = blockpos.offset(j, i, k);
                            BlockState blockstate = level.getBlockState(blockpos1);
                            Block block = blockstate.getBlock();
                            if (block instanceof RedstoneInfestedBlock && (level2 = this.silverfish.level()) instanceof ServerLevel) {
                                ServerLevel sl = (ServerLevel)level2;
                                if (EventHooks.canEntityGrief((ServerLevel)sl, (Entity)this.silverfish)) {
                                    level.destroyBlock(blockpos1, true, (Entity)this.silverfish);
                                } else {
                                    level.setBlock(blockpos1, ((RedstoneInfestedBlock)block).hostStateByInfested(level.getBlockState(blockpos1)), 3);
                                }
                                if (randomsource.nextBoolean()) {
                                    return;
                                }
                            }
                            k = (k <= 0 ? 1 : 0) - k;
                        }
                        j = (j <= 0 ? 1 : 0) - j;
                    }
                    i = (i <= 0 ? 1 : 0) - i;
                }
            }
        }
    }
}

