/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.entity.AbstractFireChargeEntity;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownFireCharge
extends AbstractFireChargeEntity {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(0.0f)), BuiltInRegistries.BLOCK.get(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    private static final float RADIUS = 1.2f;
    private int noDeflectTicks = 5;

    public ThrownFireCharge(EntityType<? extends AbstractFireChargeEntity> p_330526_, Level p_330063_) {
        super(p_330526_, p_330063_);
    }

    public ThrownFireCharge(Player p_336321_, Level p_330515_, double p_330095_, double p_333760_, double p_334828_) {
        super(TTEntityRegistry.FIRE_CHARGE.get(), p_330515_, (Entity)p_336321_, p_330095_, p_333760_, p_334828_);
    }

    public ThrownFireCharge(Level p_333074_, double p_329691_, double p_335041_, double p_329004_, Vec3 p_342087_) {
        super(TTEntityRegistry.FIRE_CHARGE.get(), p_329691_, p_335041_, p_329004_, p_342087_, p_333074_);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.noDeflectTicks > 0) {
            --this.noDeflectTicks;
        }
    }

    public boolean deflect(ProjectileDeflection p_342982_, @Nullable Entity p_343086_, @Nullable Entity p_342755_, boolean p_342935_) {
        return this.noDeflectTicks > 0 ? false : super.deflect(p_342982_, p_343086_, p_342755_, p_342935_);
    }

    @Override
    protected void onHit(HitResult p_37218_) {
        Level level;
        super.onHit(p_37218_);
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, true, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean hurtServer(ServerLevel sl, DamageSource p_37381_, float p_37382_) {
        return false;
    }
}

