/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.entity.AI.NearestAttackableTrickyTargetGoal;
import com.belgie.tricky_trials.common.entity.AI.NearestHealableTrickyTargetGoal;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class VilerWitchEntity
extends Monster
implements RangedAttackMob {
    private static final ResourceLocation SPEED_MODIFIER_DRINKING_ID = ResourceLocation.withDefaultNamespace((String)"drinking");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_ID, -0.25, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Boolean> DATA_USING_ITEM = SynchedEntityData.defineId(VilerWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int usingTime;
    private NearestHealableTrickyTargetGoal<Monster> healRaidersGoal;
    private NearestAttackableTrickyTargetGoal<Player> attackPlayersGoal;

    public VilerWitchEntity(EntityType<? extends VilerWitchEntity> p_34134_, Level p_34135_) {
        super(p_34134_, p_34135_);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.healRaidersGoal = new NearestHealableTrickyTargetGoal<Monster>((Mob)this, Monster.class, true, (p, p_341443_) -> p_341443_ != null && p.getType() != TTEntityRegistry.VILER_WITCH.get());
        this.attackPlayersGoal = new NearestAttackableTrickyTargetGoal<Player>((Mob)this, Player.class, 10, true, false, null);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{VilerWitchEntity.class}));
        this.targetSelector.addGoal(2, this.healRaidersGoal);
        this.targetSelector.addGoal(3, this.attackPlayersGoal);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_330124_) {
        super.defineSynchedData(p_330124_);
        p_330124_.define(DATA_USING_ITEM, (Object)false);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TTSoundRegistry.VILER_WITCH_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34154_) {
        return (SoundEvent)TTSoundRegistry.VILER_WITCH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.VILER_WITCH_DEATH.get();
    }

    public void setUsingItem(boolean p_34164_) {
        this.getEntityData().set(DATA_USING_ITEM, (Object)p_34164_);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.getEntityData().get(DATA_USING_ITEM);
    }

    public float getVoicePitch() {
        return -0.6f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public void aiStep() {
        if (!this.level().isClientSide && this.isAlive()) {
            this.healRaidersGoal.decrementCooldown();
            if (this.healRaidersGoal.getCooldown() <= 0) {
                this.attackPlayersGoal.setCanAttack(true);
            } else {
                this.attackPlayersGoal.setCanAttack(false);
            }
            if (this.isDrinkingPotion()) {
                if (this.usingTime-- <= 0) {
                    this.setUsingItem(false);
                    ItemStack $$0 = this.getMainHandItem();
                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    PotionContents $$1 = (PotionContents)$$0.get(DataComponents.POTION_CONTENTS);
                    if ($$0.is(Items.POTION) && $$1 != null) {
                        $$1.forEachEffect(arg_0 -> ((VilerWitchEntity)this).addEffect(arg_0));
                    }
                    this.gameEvent((Holder)GameEvent.DRINK);
                    this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_DRINKING.id());
                }
            } else {
                Holder $$2 = null;
                if (this.random.nextFloat() < 0.15f && this.isEyeInFluid(FluidTags.WATER) && !this.hasEffect(MobEffects.WATER_BREATHING)) {
                    $$2 = Potions.WATER_BREATHING;
                } else if (this.random.nextFloat() < 0.15f && (this.isOnFire() || this.getLastDamageSource() != null && this.getLastDamageSource().is(DamageTypeTags.IS_FIRE)) && !this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                    $$2 = Potions.FIRE_RESISTANCE;
                } else if (this.random.nextFloat() < 0.05f && this.getHealth() < this.getMaxHealth()) {
                    $$2 = Potions.HEALING;
                } else if (this.random.nextFloat() < 0.5f && this.getTarget() != null && !this.hasEffect(MobEffects.MOVEMENT_SPEED) && this.getTarget().distanceToSqr((Entity)this) > 121.0) {
                    $$2 = Potions.SWIFTNESS;
                }
                if ($$2 != null) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, PotionContents.createItemStack((Item)Items.POTION, (Holder)$$2));
                    this.usingTime = this.getMainHandItem().getUseDuration((LivingEntity)this);
                    this.setUsingItem(true);
                    if (!this.isSilent()) {
                        this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), (SoundEvent)TTSoundRegistry.VILER_WTICH_DRINK.get(), this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
                    }
                    AttributeInstance $$3 = this.getAttribute(Attributes.MOVEMENT_SPEED);
                    $$3.removeModifier(SPEED_MODIFIER_DRINKING_ID);
                    $$3.addTransientModifier(SPEED_MODIFIER_DRINKING);
                }
            }
            if (this.random.nextFloat() < 7.5E-4f) {
                this.level().broadcastEntityEvent((Entity)this, (byte)15);
            }
        }
        super.aiStep();
    }

    public void handleEntityEvent(byte p_34138_) {
        if (p_34138_ == 15) {
            for (int $$1 = 0; $$1 < this.random.nextInt(35) + 10; ++$$1) {
                this.level().addParticle((ParticleOptions)ParticleTypes.WITCH, this.getX() + this.random.nextGaussian() * (double)0.13f, this.getBoundingBox().maxY + 0.5 + this.random.nextGaussian() * (double)0.13f, this.getZ() + this.random.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.handleEntityEvent(p_34138_);
        }
    }

    protected float getDamageAfterMagicAbsorb(DamageSource p_34149_, float p_34150_) {
        p_34150_ = super.getDamageAfterMagicAbsorb(p_34149_, p_34150_);
        if (p_34149_.getEntity() == this) {
            p_34150_ = 0.0f;
        }
        if (p_34149_.is(DamageTypeTags.WITCH_RESISTANT_TO)) {
            p_34150_ *= 0.15f;
        }
        return p_34150_;
    }

    public void performRangedAttack(LivingEntity p_34143_, float p_34144_) {
        if (!this.isDrinkingPotion()) {
            Vec3 $$2 = p_34143_.getDeltaMovement();
            double $$3 = p_34143_.getX() + $$2.x - this.getX();
            double $$4 = p_34143_.getEyeY() - (double)1.1f - this.getY();
            double $$5 = p_34143_.getZ() + $$2.z - this.getZ();
            double $$6 = Math.sqrt($$3 * $$3 + $$5 * $$5);
            Holder $$7 = Potions.HARMING;
            if (p_34143_ instanceof Monster) {
                $$7 = p_34143_.getHealth() <= 4.0f ? Potions.HEALING : Potions.REGENERATION;
                this.setTarget(null);
            } else if ($$6 >= 8.0 && !p_34143_.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                $$7 = Potions.SLOWNESS;
            } else if (p_34143_.getHealth() >= 8.0f && !p_34143_.hasEffect(MobEffects.POISON)) {
                $$7 = Potions.POISON;
            } else if ($$6 <= 3.0 && !p_34143_.hasEffect(MobEffects.WEAKNESS) && this.random.nextFloat() < 0.25f) {
                $$7 = Potions.WEAKNESS;
            }
            ThrownPotion $$8 = new ThrownPotion(EntityType.POTION, this.level());
            $$8.setItem(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)$$7));
            $$8.setXRot($$8.getXRot() - -20.0f);
            $$8.shoot($$3, $$4 + $$6 * 0.2, $$5, 0.75f, 8.0f);
            if (!this.isSilent()) {
                this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * -0.4f);
            }
            this.level().addFreshEntity((Entity)$$8);
        }
    }
}

