/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.layer;

import com.belgie.tricky_trials.common.entity.model.MoolinModel;
import com.belgie.tricky_trials.common.entity.renderer.state.MoolinRenderState;
import com.belgie.tricky_trials.utils.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class MoolinArmorLayer
extends RenderLayer<MoolinRenderState, MoolinModel> {
    private final MoolinModel adultModel;
    private final EquipmentLayerRenderer equipmentRenderer;
    private static final Map<Crackiness.Level, ResourceLocation> ARMOR_CRACK_LOCATIONS = Map.of(Crackiness.Level.LOW, ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"textures/entity/moolin/armor_crackiness_low.png"), Crackiness.Level.MEDIUM, ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"textures/entity/moolin/armor_crackiness_medium.png"), Crackiness.Level.HIGH, ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"textures/entity/moolin/armor_crackiness_high.png"));

    public MoolinArmorLayer(RenderLayerParent<MoolinRenderState, MoolinModel> renderer, EntityModelSet entityModels, EquipmentLayerRenderer equipmentRenderer) {
        super(renderer);
        this.adultModel = new MoolinModel(entityModels.bakeLayer(ClientEntityRegistry.MOOLIN_ARMOR));
        this.equipmentRenderer = equipmentRenderer;
    }

    public void render(PoseStack p_316890_, MultiBufferSource p_316537_, int p_316674_, MoolinRenderState p_360943_, float p_316775_, float p_316264_) {
        ItemStack itemstack = p_360943_.bodyArmorItem;
        Equippable equippable = (Equippable)itemstack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.assetId().isEmpty()) {
            MoolinModel wolfmodel = this.adultModel;
            wolfmodel.setupAnim(p_360943_);
            this.equipmentRenderer.renderLayers(EquipmentClientInfo.LayerType.WOLF_BODY, (ResourceKey)equippable.assetId().get(), (Model)wolfmodel, itemstack, p_316890_, p_316537_, p_316674_);
            this.maybeRenderCracks(p_316890_, p_316537_, p_316674_, itemstack, (Model)wolfmodel);
        }
    }

    private void maybeRenderCracks(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, ItemStack armorItem, Model model) {
        Crackiness.Level crackiness$level = Crackiness.WOLF_ARMOR.byDamage(armorItem);
        if (crackiness$level != Crackiness.Level.NONE) {
            ResourceLocation resourcelocation = ARMOR_CRACK_LOCATIONS.get(crackiness$level);
            VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.armorTranslucent((ResourceLocation)resourcelocation));
            model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }
}

