/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.model;

import com.belgie.tricky_trials.common.entity.animations.BlitzeAnimations;
import com.belgie.tricky_trials.common.entity.renderer.state.BlitzeRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class BlitzeModel
extends EntityModel<BlitzeRenderState> {
    private final ModelPart root;

    public BlitzeModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.5f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.5f, (float)0.0f));
        PartDefinition head2 = head.addOrReplaceChild("head2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head3 = head2.addOrReplaceChild("head3", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.01f)).texOffs(4, 8).addBox(-4.5f, -2.5f, -4.5f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition boulder1 = root.addOrReplaceChild("boulder1", CubeListBuilder.create().texOffs(8, 8).mirror().addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)9.5f, (float)0.0f));
        PartDefinition boulder2 = root.addOrReplaceChild("boulder2", CubeListBuilder.create().texOffs(8, 8).mirror().addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition boulder3 = root.addOrReplaceChild("boulder3", CubeListBuilder.create().texOffs(8, 8).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)0.0f, (float)0.0f));
        PartDefinition boulder4 = root.addOrReplaceChild("boulder4", CubeListBuilder.create().texOffs(8, 8).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)0.0f, (float)0.0f));
        PartDefinition boulder5 = root.addOrReplaceChild("boulder5", CubeListBuilder.create().texOffs(8, 8).mirror().addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(BlitzeRenderState entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.shoot, BlitzeAnimations.ATTACK, entity.ageInTicks);
        this.animate(entity.slide, BlitzeAnimations.SLIDE, entity.ageInTicks);
        this.animate(entity.sideback, BlitzeAnimations.SLIDE, entity.ageInTicks);
        this.animate(entity.idle, BlitzeAnimations.IDLE, entity.ageInTicks);
    }
}

