/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.model;

import com.belgie.tricky_trials.common.entity.animations.BlitzzeAnimations;
import com.belgie.tricky_trials.common.entity.renderer.state.BubzeRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class BubzeModel
extends EntityModel<BubzeRenderState> {
    private final ModelPart root;

    public BubzeModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition rod1 = body.addOrReplaceChild("rod1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition rod_1_2 = rod1.addOrReplaceChild("rod_1_2", CubeListBuilder.create().texOffs(32, 3).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rod2 = body.addOrReplaceChild("rod2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.5f, (float)4.0f));
        PartDefinition rod_2_2 = rod2.addOrReplaceChild("rod_2_2", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rod3 = body.addOrReplaceChild("rod3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)9.5f, (float)0.0f));
        PartDefinition rod_3_2 = rod3.addOrReplaceChild("rod_3_2", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -2.5f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rod4 = body.addOrReplaceChild("rod4", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.5f, (float)-4.0f));
        PartDefinition rod_4_2 = rod4.addOrReplaceChild("rod_4_2", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rod5 = body.addOrReplaceChild("rod5", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)3.5f, (float)0.0f));
        PartDefinition rod_5_2 = rod5.addOrReplaceChild("rod_5_2", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rod6 = body.addOrReplaceChild("rod6", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)3.5f, (float)0.0f));
        PartDefinition rod_6_2 = rod6.addOrReplaceChild("rod_6_2", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(BubzeRenderState entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.swim, BlitzzeAnimations.SWIM, entity.ageInTicks);
        this.animate(entity.riptide, BlitzzeAnimations.RIPTIDE, entity.ageInTicks);
        this.animate(entity.shoot, BlitzzeAnimations.ATTACK, entity.ageInTicks);
    }
}

