/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.model;

import com.belgie.tricky_trials.common.entity.animations.CopperGolemAnimations;
import com.belgie.tricky_trials.common.entity.renderer.state.CopperGolemRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class CopperGolemModel
extends EntityModel<CopperGolemRenderState> {
    private final ModelPart Main;
    private final ModelPart root;

    public CopperGolemModel(ModelPart root) {
        super(root);
        this.root = root;
        this.Main = root.getChild("main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 18).addBox(-5.0f, -5.0f, -3.0f, 10.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition spin = head.addOrReplaceChild("spin", CubeListBuilder.create().texOffs(0, 0).addBox(-5.5f, -7.0f, -5.5f, 11.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rod = spin.addOrReplaceChild("rod", CubeListBuilder.create().texOffs(16, 30).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 18).addBox(-2.0f, -8.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition active_rod = rod.addOrReplaceChild("active_rod", CubeListBuilder.create().texOffs(32, 26).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition nose = spin.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-5.5f));
        PartDefinition active_head = spin.addOrReplaceChild("active_head", CubeListBuilder.create().texOffs(0, 46).addBox(-5.5f, -3.5f, -5.5f, 11.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.5f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(48, 11).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-4.0f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(48, 11).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)-4.0f, (float)0.0f));
        PartDefinition active_body = body.addOrReplaceChild("active_body", CubeListBuilder.create().texOffs(32, 34).addBox(-5.0f, -3.0f, -3.0f, 10.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(33, 0).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-4.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(33, 0).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-4.0f, (float)0.0f));
        PartDefinition arms = partdefinition.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition legs = partdefinition.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CopperGolemRenderState entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.freeze, CopperGolemAnimations.OXIDIZED, entity.ageInTicks);
        this.animate(entity.strike, CopperGolemAnimations.LIGHTNING, entity.ageInTicks);
        this.animate(entity.idle, CopperGolemAnimations.IDLE, entity.ageInTicks);
        this.animate(entity.walk, CopperGolemAnimations.ACTIVATE, entity.ageInTicks);
        this.animateWalk(CopperGolemAnimations.WALK, entity.walkAnimationPos, entity.walkAnimationSpeed, 2.0f, 2.5f);
    }
}

