/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.model;

import com.belgie.tricky_trials.common.entity.animations.GrunterAnimations;
import com.belgie.tricky_trials.common.entity.renderer.state.GrunterRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class GrunterModel
extends EntityModel<GrunterRenderState> {
    private final ModelPart body;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart root;

    public GrunterModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.leg0 = root.getChild("leg0");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-5.0f, -9.25f, -9.0f, 10.0f, 9.0f, 18.0f, new CubeDeformation(0.0f)).texOffs(0, -20).addBox(0.0f, -13.25f, -8.0f, 0.0f, 12.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.25f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-9.25f, (float)-9.0f));
        PartDefinition head2 = head.addOrReplaceChild("head2", CubeListBuilder.create().texOffs(20, 39).addBox(-4.0f, -7.0f, -8.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition eye = head2.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(44, 42).addBox(-1.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-8.01f));
        PartDefinition hair = head2.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(52, 47).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-8.02f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(0, 39).mirror().addBox(-2.5f, -1.0f, -3.5f, 4.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-6.0f, (float)6.0f, (float)-6.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 39).mirror().addBox(-1.5f, -1.0f, -3.5f, 4.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-7.0f, (float)6.0f, (float)7.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 39).addBox(-2.5f, -1.0f, -3.5f, 4.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)6.0f, (float)-6.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 39).addBox(-2.5f, -1.0f, -2.5f, 4.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)6.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)80, (int)80);
    }

    public void setupAnim(GrunterRenderState entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(GrunterAnimations.WALK, entity.walkAnimationPos, entity.walkAnimationSpeed, 6.0f, 100.0f);
        this.animate(entity.idle, GrunterAnimations.IDLE, entity.ageInTicks);
    }
}

