/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.model;

import com.belgie.tricky_trials.common.entity.animations.HeavyCoreBossAnimations;
import com.belgie.tricky_trials.common.entity.renderer.state.HeavyCoreBossRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class HeavyCoreBossModel
extends EntityModel<HeavyCoreBossRenderState> {
    private final ModelPart root;

    public HeavyCoreBossModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-18.0f, (float)0.0f));
        PartDefinition left_magnet = body.addOrReplaceChild("left_magnet", CubeListBuilder.create(), PartPose.offset((float)-4.75f, (float)-8.0f, (float)0.0f));
        PartDefinition cube_r1 = left_magnet.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(67, 67).mirror().addBox(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.75f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition right_magnet = body.addOrReplaceChild("right_magnet", CubeListBuilder.create(), PartPose.offset((float)4.75f, (float)-8.0f, (float)0.0f));
        PartDefinition cube_r2 = right_magnet.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(67, 67).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.75f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 29).addBox(-6.0f, -12.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-20.0f, (float)0.0f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -5.5f, -7.0f, 18.0f, 11.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.5f, (float)0.0f));
        PartDefinition chest_open = chest.addOrReplaceChild("chest_open", CubeListBuilder.create().texOffs(0, 89).addBox(-9.0f, -5.5f, 0.0f, 18.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition left_arm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(50, 0).addBox(-5.0f, -3.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(56, 17).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(40, 53).addBox(-4.0f, 1.0f, -4.0f, 8.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 43).addBox(-5.0f, 12.0f, -5.0f, 10.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-15.0f, (float)-32.0f, (float)0.0f));
        PartDefinition right_arm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(50, 0).mirror().addBox(-5.0f, -3.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(56, 17).mirror().addBox(-4.0f, -4.0f, -4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 53).mirror().addBox(-4.0f, 1.0f, -4.0f, 8.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 43).mirror().addBox(-5.0f, 12.0f, -5.0f, 10.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)15.0f, (float)-32.0f, (float)0.0f));
        PartDefinition pulse1 = root.addOrReplaceChild("pulse1", CubeListBuilder.create().texOffs(0, 25).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition pulse2 = root.addOrReplaceChild("pulse2", CubeListBuilder.create().texOffs(0, 25).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition pulse3 = root.addOrReplaceChild("pulse3", CubeListBuilder.create().texOffs(0, 25).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition pulse4 = root.addOrReplaceChild("pulse4", CubeListBuilder.create().texOffs(0, 25).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition heavy_core = root.addOrReplaceChild("heavy_core", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition core = heavy_core.addOrReplaceChild("core", CubeListBuilder.create().texOffs(0, 64).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(HeavyCoreBossRenderState entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.idle, HeavyCoreBossAnimations.IDLE, entity.ageInTicks);
        this.animate(entity.summon, HeavyCoreBossAnimations.SUMMON, entity.ageInTicks);
        this.animate(entity.attack, HeavyCoreBossAnimations.ATTACK, entity.ageInTicks);
        this.animate(entity.shoot, HeavyCoreBossAnimations.LAUNCH, entity.ageInTicks);
        this.animate(entity.slide, HeavyCoreBossAnimations.SLIDE, entity.ageInTicks);
    }
}

