/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.model;

import com.belgie.tricky_trials.common.entity.animations.MoolinBeastAnimations;
import com.belgie.tricky_trials.common.entity.renderer.state.MoolinBeastRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class MoolinBeastModel
extends EntityModel<MoolinBeastRenderState> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart root;

    public MoolinBeastModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.left_arm = this.body.getChild("left_arm");
        this.right_arm = this.body.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 24).addBox(-6.0f, -14.0f, -5.0f, 12.0f, 14.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)1.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 30).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(-2.0f, -3.0f, -5.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 0).mirror().addBox(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(10, 0).addBox(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 5).addBox(4.0f, -12.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 5).mirror().addBox(-6.0f, -12.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-14.0f, (float)-4.0f));
        PartDefinition crafter = body.addOrReplaceChild("crafter", CubeListBuilder.create().texOffs(26, 0).addBox(-5.0f, -5.0f, -2.0f, 10.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)7.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(54, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 66).addBox(-3.01f, -4.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)9.0f, (float)-11.0f, (float)1.0f));
        PartDefinition left_lamp = left_arm.addOrReplaceChild("left_lamp", CubeListBuilder.create().texOffs(0, 66).addBox(-3.51f, -3.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-0.5f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(54, 0).mirror().addBox(-3.0f, -3.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(28, 66).mirror().addBox(-3.99f, -4.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(-0.01f)).mirror(false), PartPose.offset((float)-9.0f, (float)-11.0f, (float)1.0f));
        PartDefinition right_lamp = right_arm.addOrReplaceChild("right_lamp", CubeListBuilder.create().texOffs(0, 66).mirror().addBox(-3.49f, -3.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-0.5f, (float)-0.5f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 14).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)14.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 14).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)14.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)80, (int)80);
    }

    public void setupAnim(MoolinBeastRenderState entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(entity.IsAggressive ? MoolinBeastAnimations.WALK_HOSTILE : MoolinBeastAnimations.WALK, entity.walkAnimationPos, entity.walkAnimationSpeed, entity.IsAggressive ? 2.0f : 8.0f, entity.IsAggressive ? 2.0f : 100.0f);
        this.animate(entity.attack, MoolinBeastAnimations.ATTACK, entity.ageInTicks);
        this.animate(entity.idle, entity.IsAggressive ? MoolinBeastAnimations.IDLE_HOSTILE : MoolinBeastAnimations.IDLE, entity.ageInTicks);
        this.animateHeadLookTarget(entity.xRot, entity.yRot);
    }

    private void animateHeadLookTarget(float p_233517_, float p_233518_) {
        this.head.xRot = p_233518_ * ((float)Math.PI / 180);
        this.head.yRot = p_233517_ * ((float)Math.PI / 180);
    }
}

