/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.model;

import com.belgie.tricky_trials.common.entity.renderer.state.MoolinRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class MoolinModel
extends EntityModel<MoolinRenderState>
implements ArmedModel {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart Root;

    public MoolinModel(ModelPart root) {
        super(root);
        this.Root = root;
        this.body = root.getChild("Body");
        this.head = root.getChild("Head");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation def) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -10.0f, -2.0f, 8.0f, 10.0f, 4.0f, def), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, def).texOffs(28, 30).addBox(-2.0f, -3.0f, -5.0f, 4.0f, 3.0f, 1.0f, def), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition head_r1 = Head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(56, 0).addBox(-7.0f, -22.4145f, 5.1564f, 2.0f, 7.0f, 2.0f, def).texOffs(56, 0).addBox(3.0f, -22.4145f, 5.1564f, 2.0f, 7.0f, 2.0f, def), PartPose.offsetAndRotation((float)1.0f, (float)12.5f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).addBox(0.0f, -1.6317f, -2.1317f, 4.0f, 10.0f, 4.0f, def), PartPose.offset((float)4.0f, (float)7.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 16).addBox(-4.0f, -1.6317f, -2.1317f, 4.0f, 10.0f, 4.0f, def), PartPose.offset((float)-4.0f, (float)7.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(32, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, def), PartPose.offset((float)-2.0f, (float)15.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(32, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, def), PartPose.offset((float)2.0f, (float)15.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(MoolinRenderState p_364094_) {
        boolean flag1;
        super.setupAnim((EntityRenderState)p_364094_);
        HumanoidModel.ArmPose humanoidmodel$armpose = p_364094_.leftArmPose;
        HumanoidModel.ArmPose humanoidmodel$armpose1 = p_364094_.rightArmPose;
        float f = p_364094_.swimAmount;
        boolean flag = p_364094_.isFallFlying;
        this.head.xRot = p_364094_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_364094_.yRot * ((float)Math.PI / 180);
        if (flag) {
            this.head.xRot = -0.7853982f;
        } else if (f > 0.0f) {
            this.head.xRot = Mth.rotLerpRad((float)f, (float)this.head.xRot, (float)-0.7853982f);
        }
        float f1 = p_364094_.walkAnimationPos;
        float f2 = p_364094_.walkAnimationSpeed;
        this.rightArm.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 2.0f * f2 * 0.5f / p_364094_.speedValue;
        this.leftArm.xRot = Mth.cos((float)(f1 * 0.6662f)) * 2.0f * f2 * 0.5f / p_364094_.speedValue;
        this.rightLeg.xRot = Mth.cos((float)(f1 * 0.6662f)) * 1.4f * f2 / p_364094_.speedValue;
        this.leftLeg.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 1.4f * f2 / p_364094_.speedValue;
        this.rightLeg.yRot = 0.005f;
        this.leftLeg.yRot = -0.005f;
        this.rightLeg.zRot = 0.005f;
        this.leftLeg.zRot = -0.005f;
        if (p_364094_.isPassenger) {
            ModelPart var10000 = this.rightArm;
            var10000.xRot += -0.62831855f;
            var10000 = this.leftArm;
            var10000.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.3113717f;
            this.rightLeg.yRot = -0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.3137167f;
            this.leftLeg.yRot = 0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        boolean bl = flag1 = p_364094_.mainArm == HumanoidArm.RIGHT;
        if (p_364094_.isUsingItem) {
            boolean flag2;
            boolean bl2 = flag2 = p_364094_.useItemHand == InteractionHand.MAIN_HAND;
            if (flag2 == flag1) {
                this.poseRightArm(p_364094_, humanoidmodel$armpose1);
            } else {
                this.poseLeftArm(p_364094_, humanoidmodel$armpose);
            }
        } else {
            boolean flag2;
            boolean bl3 = flag2 = flag1 ? humanoidmodel$armpose.isTwoHanded() : humanoidmodel$armpose1.isTwoHanded();
            if (flag1 != flag2) {
                this.poseLeftArm(p_364094_, humanoidmodel$armpose);
                this.poseRightArm(p_364094_, humanoidmodel$armpose1);
            } else {
                this.poseRightArm(p_364094_, humanoidmodel$armpose1);
                this.poseLeftArm(p_364094_, humanoidmodel$armpose);
            }
        }
        this.setupAttackAnimation(p_364094_, p_364094_.ageInTicks);
        if (humanoidmodel$armpose1 != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)p_364094_.ageInTicks, (float)1.0f);
        }
        if (humanoidmodel$armpose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)p_364094_.ageInTicks, (float)-1.0f);
        }
        if (f > 0.0f) {
            float f5;
            float f4;
            float f7 = f1 % 26.0f;
            HumanoidArm humanoidarm = p_364094_.attackArm;
            float f3 = humanoidarm == HumanoidArm.RIGHT && p_364094_.attackTime > 0.0f ? 0.0f : f;
            float f6 = f4 = humanoidarm == HumanoidArm.LEFT && p_364094_.attackTime > 0.0f ? 0.0f : f;
            if (!p_364094_.isUsingItem) {
                if (f7 < 14.0f) {
                    this.leftArm.xRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.xRot, (float)0.0f);
                    this.rightArm.xRot = Mth.lerp((float)f3, (float)this.rightArm.xRot, (float)0.0f);
                    this.leftArm.yRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.yRot, (float)((float)Math.PI));
                    this.rightArm.yRot = Mth.lerp((float)f3, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.zRot, (float)((float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f7) / this.quadraticArmUpdate(14.0f)));
                    this.rightArm.zRot = Mth.lerp((float)f3, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f7) / this.quadraticArmUpdate(14.0f)));
                } else if (f7 >= 14.0f && f7 < 22.0f) {
                    f5 = (f7 - 14.0f) / 8.0f;
                    this.leftArm.xRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.xRot, (float)(1.5707964f * f5));
                    this.rightArm.xRot = Mth.lerp((float)f3, (float)this.rightArm.xRot, (float)(1.5707964f * f5));
                    this.leftArm.yRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.yRot, (float)((float)Math.PI));
                    this.rightArm.yRot = Mth.lerp((float)f3, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.zRot, (float)(5.012389f - 1.8707964f * f5));
                    this.rightArm.zRot = Mth.lerp((float)f3, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * f5));
                } else if (f7 >= 22.0f && f7 < 26.0f) {
                    f5 = (f7 - 22.0f) / 4.0f;
                    this.leftArm.xRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.xRot, (float)(1.5707964f - 1.5707964f * f5));
                    this.rightArm.xRot = Mth.lerp((float)f3, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * f5));
                    this.leftArm.yRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.yRot, (float)((float)Math.PI));
                    this.rightArm.yRot = Mth.lerp((float)f3, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.zRot, (float)((float)Math.PI));
                    this.rightArm.zRot = Mth.lerp((float)f3, (float)this.rightArm.zRot, (float)((float)Math.PI));
                }
            }
            f5 = 0.3f;
            float f62 = 0.33333334f;
            this.leftLeg.xRot = Mth.lerp((float)f, (float)this.leftLeg.xRot, (float)(0.3f * Mth.cos((float)(f1 * 0.33333334f + (float)Math.PI))));
            this.rightLeg.xRot = Mth.lerp((float)f, (float)this.rightLeg.xRot, (float)(0.3f * Mth.cos((float)(f1 * 0.33333334f))));
        }
    }

    private void poseRightArm(MoolinRenderState p_362371_, HumanoidModel.ArmPose p_366231_) {
        switch (p_366231_.ordinal()) {
            case 0: {
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 1: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.rightArm.yRot = -0.1f + this.head.yRot;
                this.leftArm.yRot = 0.1f + this.head.yRot + 0.4f;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case 4: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - (float)Math.PI;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
                break;
            }
            case 7: {
                this.rightArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - 0.0f), (float)-2.4f, (float)3.3f);
                this.rightArm.yRot = this.head.yRot - 0.2617994f;
                break;
            }
            case 8: {
                this.rightArm.xRot = Mth.clamp((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.rightArm.yRot = this.head.yRot - 0.5235988f;
                break;
            }
            case 9: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.62831855f;
                this.rightArm.yRot = 0.0f;
            }
        }
    }

    private void poseLeftArm(MoolinRenderState p_363560_, HumanoidModel.ArmPose p_370002_) {
        switch (p_370002_.ordinal()) {
            case 0: {
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 1: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.rightArm.yRot = -0.1f + this.head.yRot - 0.4f;
                this.leftArm.yRot = 0.1f + this.head.yRot;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case 4: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - (float)Math.PI;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)false);
                break;
            }
            case 7: {
                this.leftArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - 0.0f), (float)-2.4f, (float)3.3f);
                this.leftArm.yRot = this.head.yRot + 0.2617994f;
                break;
            }
            case 8: {
                this.leftArm.xRot = Mth.clamp((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.leftArm.yRot = this.head.yRot + 0.5235988f;
                break;
            }
            case 9: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.62831855f;
                this.leftArm.yRot = 0.0f;
            }
        }
    }

    protected void setupAttackAnimation(MoolinRenderState p_367078_, float p_102859_) {
        float f = p_367078_.attackTime;
        if (!(f <= 0.0f)) {
            HumanoidArm humanoidarm = p_367078_.attackArm;
            ModelPart modelpart = this.getArm(humanoidarm);
            this.body.yRot = Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                ModelPart var10000 = this.body;
                var10000.yRot *= -1.0f;
            }
            float f2 = p_367078_.ageScale;
            this.rightArm.z = Mth.sin((float)this.body.yRot) * 5.0f * f2;
            this.rightArm.x = -Mth.cos((float)this.body.yRot) * 5.0f * f2;
            this.leftArm.z = -Mth.sin((float)this.body.yRot) * 5.0f * f2;
            this.leftArm.x = Mth.cos((float)this.body.yRot) * 5.0f * f2;
            this.rightArm.yRot += this.body.yRot;
            this.leftArm.yRot += this.body.yRot;
            this.leftArm.xRot += this.body.yRot;
            float $$5 = 1.0f - f;
            $$5 *= $$5;
            $$5 *= $$5;
            $$5 = 1.0f - $$5;
            float f3 = Mth.sin((float)($$5 * (float)Math.PI));
            float f4 = Mth.sin((float)(f * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f3 * 1.2f + f4;
            modelpart.yRot += this.body.yRot * 2.0f;
            modelpart.zRot += Mth.sin((float)(f * (float)Math.PI)) * -0.4f;
        }
    }

    protected ModelPart getArm(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    private float quadraticArmUpdate(float p_102834_) {
        return -65.0f * p_102834_ + p_102834_ * p_102834_;
    }

    public void translateToHand(HumanoidArm p_233322_, PoseStack p_233323_) {
        this.root.translateAndRotate(p_233323_);
        this.body.translateAndRotate(p_233323_);
        p_233323_.translate(-0.35f, -0.6625f, -0.1275f);
        p_233323_.mulPose(Axis.XP.rotation(this.rightArm.xRot));
    }
}

