/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.renderer;

import com.belgie.tricky_trials.common.entity.CopperSpikeEntity;
import com.belgie.tricky_trials.common.entity.model.CopperSpikeModel;
import com.belgie.tricky_trials.common.entity.renderer.state.CopperSpikeRenderState;
import com.belgie.tricky_trials.utils.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CopperSpikeRenderer
extends EntityRenderer<CopperSpikeEntity, CopperSpikeRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"textures/entity/copper_spike.png");
    private final CopperSpikeModel model;

    public CopperSpikeRenderer(EntityRendererProvider.Context p_174100_) {
        super(p_174100_);
        this.model = new CopperSpikeModel(p_174100_.bakeLayer(ClientEntityRegistry.COPPER_SPIKE));
    }

    public CopperSpikeRenderState createRenderState() {
        return new CopperSpikeRenderState();
    }

    public void render(CopperSpikeRenderState p_114528_, PoseStack p_114531_, MultiBufferSource p_114532_, int p_114533_) {
        float $$6 = p_114528_.biteProgress;
        if ($$6 != 0.0f) {
            float $$7 = 2.0f;
            if ($$6 > 0.9f) {
                $$7 *= (1.0f - $$6) / 0.1f;
            }
            p_114531_.pushPose();
            p_114531_.mulPose(Axis.YP.rotationDegrees(90.0f - p_114528_.yRot));
            p_114531_.scale(-$$7, -$$7, $$7);
            float $$8 = 0.03125f;
            p_114531_.translate(0.0, -0.626, 0.0);
            p_114531_.scale(0.5f, 0.5f, 0.5f);
            this.model.setupAnim(p_114528_);
            VertexConsumer $$5 = p_114532_.getBuffer(this.model.renderType(TEXTURE_LOCATION));
            this.model.renderToBuffer(p_114531_, $$5, p_114533_, OverlayTexture.NO_OVERLAY);
            p_114531_.popPose();
            super.render((EntityRenderState)p_114528_, p_114531_, p_114532_, p_114533_);
        }
    }

    public ResourceLocation getTextureLocation(CopperSpikeEntity p_114526_) {
        return TEXTURE_LOCATION;
    }
}

