/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.renderer;

import com.belgie.tricky_trials.common.entity.HeavyCoreBullet;
import com.belgie.tricky_trials.common.entity.model.HeavyCoreBulletModel;
import com.belgie.tricky_trials.utils.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HeavyCoreBulletRenderer
extends EntityRenderer<HeavyCoreBullet, EntityRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"textures/entity/heavy_core_bullet.png");
    private static final RenderType RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)TEXTURE_LOCATION);
    private final HeavyCoreBulletModel model;

    public HeavyCoreBulletRenderer(EntityRendererProvider.Context p_174368_) {
        super(p_174368_);
        this.model = new HeavyCoreBulletModel(p_174368_.bakeLayer(ClientEntityRegistry.HEAVY_CORE_BULLET));
    }

    protected int getBlockLightLevel(EntityRenderState p_115869_, BlockPos p_115870_) {
        return 15;
    }

    public void render(EntityRenderState p_368794_, PoseStack p_115853_, MultiBufferSource p_115854_, int p_115855_) {
        p_115853_.pushPose();
        float $$4 = p_368794_.ageInTicks;
        p_115853_.translate(0.0f, 0.15f, 0.0f);
        p_115853_.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)($$4 * 0.1f)) * 180.0f));
        p_115853_.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)($$4 * 0.1f)) * 180.0f));
        p_115853_.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)($$4 * 0.15f)) * 360.0f));
        p_115853_.scale(-0.5f, -0.5f, 0.5f);
        this.model.setupAnim(p_368794_);
        VertexConsumer $$5 = p_115854_.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        this.model.renderToBuffer(p_115853_, $$5, p_115855_, OverlayTexture.NO_OVERLAY);
        p_115853_.scale(1.5f, 1.5f, 1.5f);
        VertexConsumer $$6 = p_115854_.getBuffer(RENDER_TYPE);
        this.model.renderToBuffer(p_115853_, $$6, p_115855_, OverlayTexture.NO_OVERLAY, 0x26FFFFFF);
        p_115853_.popPose();
        super.render(p_368794_, p_115853_, p_115854_, p_115855_);
    }

    public EntityRenderState createRenderState() {
        return new EntityRenderState();
    }

    public ResourceLocation getTextureLocation(EntityRenderState p_115860_) {
        return TEXTURE_LOCATION;
    }
}

