/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Zombie;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class TTAbstractZombieRenderer<T extends Zombie, S extends ZombieRenderState, M extends HumanoidModel<S>>
extends HumanoidMobRenderer<T, S, M> {
    private static final ResourceLocation ZOMBIE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/zombie.png");

    protected TTAbstractZombieRenderer(EntityRendererProvider.Context p_173910_, M p_173911_, M p_173912_, M p_173913_) {
        super(p_173910_, p_173911_, 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, p_173912_, p_173913_, p_173910_.getEquipmentRenderer()));
    }

    protected void scale(S renderState, PoseStack poseStack) {
        if (((ZombieRenderState)renderState).isBaby) {
            poseStack.scale(0.6f, 0.6f, 0.6f);
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.scale(renderState, poseStack);
    }

    public ResourceLocation getTextureLocation(ZombieRenderState p_113771_) {
        return ZOMBIE_LOCATION;
    }

    protected boolean isShaking(S p_361791_) {
        return super.isShaking(p_361791_) || ((ZombieRenderState)p_361791_).isConverting;
    }
}

