/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.items;

import com.belgie.tricky_trials.core.TTItemRegistry;
import com.belgie.tricky_trials.core.TTParticleRegistry;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EchoFlailItem
extends Item {
    public EchoFlailItem(ToolMaterial p_43269_, Item.Properties p_43272_) {
        super(p_43272_.component(DataComponents.TOOL, (Object)EchoFlailItem.createToolProperties()).component(TTItemRegistry.FLAIL_RANGE.get(), (Object)3));
    }

    private static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"player.entity_interaction_range"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canAttackBlock(BlockState p_43291_, Level p_43292_, BlockPos p_43293_, Player p_43294_) {
        return !p_43294_.isCreative();
    }

    public boolean hurtEnemy(ItemStack p_43278_, LivingEntity p_43279_, LivingEntity p_43280_) {
        Iterator var20;
        float RANGE = p_43278_.has(TTItemRegistry.FLAIL_RANGE.get()) ? (float)((Integer)p_43278_.get(TTItemRegistry.FLAIL_RANGE.get())).intValue() : 3.0f;
        int i = (int)Mth.clamp((float)5.0f, (float)0.0f, (float)200.0f);
        Iterator it = var20 = p_43279_.level().getEntitiesOfClass(Mob.class, p_43279_.getBoundingBox().inflate((double)RANGE)).iterator();
        while (it.hasNext()) {
            Level level;
            Mob entity = (Mob)it.next();
            if (!(entity instanceof TamableAnimal)) {
                entity.knockback((double)0.4f, (double)Mth.sin((float)(p_43280_.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(p_43280_.getYRot() * ((float)Math.PI / 180)))));
                entity.hurt(p_43280_.damageSources().mobAttack(p_43280_), 4.0f);
            }
            if (!((level = p_43279_.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = entity.blockPosition().getCenter().add(0.0, 0.5, 0.0);
            serverLevel.sendParticles((ParticleOptions)TTParticleRegistry.SCULK_HEART.get(), vec3.x, vec3.y, vec3.z, i, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
        }
        p_43278_.hurtAndBreak(1, p_43280_, EquipmentSlot.MAINHAND);
        return true;
    }
}

