/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.items;

import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;

public class HeavyArmorItem
extends Item {
    public HeavyArmorItem(ArmorMaterial material, ArmorType armorType, Item.Properties properties) {
        super(HeavyArmorItem.humanoidProperties(material, properties, armorType));
    }

    public static Item.Properties humanoidProperties(ArmorMaterial p_329451_, Item.Properties properties, ArmorType armorType) {
        return properties.durability(armorType.getDurability(p_329451_.durability())).attributes(HeavyArmorItem.createAttributes(p_329451_, armorType)).enchantable(p_329451_.enchantmentValue()).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)armorType.getSlot()).setEquipSound(p_329451_.equipSound()).setAsset(p_329451_.assetId()).build()).repairable(p_329451_.repairIngredient());
    }

    private static ItemAttributeModifiers createAttributes(ArmorMaterial p_329451_, ArmorType armorType) {
        int i = p_329451_.defense().getOrDefault(armorType, 0);
        ItemAttributeModifiers.Builder itemattributemodifiers$builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)armorType.getSlot());
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("armor." + armorType.getName()));
        itemattributemodifiers$builder.add(Attributes.ARMOR, new AttributeModifier(resourcelocation, (double)i, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        itemattributemodifiers$builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourcelocation, (double)p_329451_.toughness(), AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        itemattributemodifiers$builder.add(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(resourcelocation, 2.0, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        if (p_329451_.knockbackResistance() > 0.0f) {
            itemattributemodifiers$builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourcelocation, (double)p_329451_.knockbackResistance(), AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        return itemattributemodifiers$builder.build();
    }
}

