/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.items;

import com.belgie.tricky_trials.common.entity.IllusionEntity;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.belgie.tricky_trials.core.TTItemRegistry;
import com.belgie.tricky_trials.core.TTParticleRegistry;
import com.belgie.tricky_trials.core.TTTriggers;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class IllusionTotemItem
extends Item {
    private final TargetingConditions vexCountTargeting = TargetingConditions.forNonCombat().range(32.0).ignoreLineOfSight().ignoreInvisibilityTesting();

    public IllusionTotemItem(Item.Properties p_41383_) {
        super(p_41383_.component(TTItemRegistry.ILLUSION_RANGE.get(), (Object)16));
    }

    public InteractionResult use(Level p_220123_, Player p_220124_, InteractionHand p_220125_) {
        ItemStack $$3 = p_220124_.getItemInHand(p_220125_);
        if ($$3.is(TTItemRegistry.ILLUSION_TOTEM.get())) {
            if (!p_220123_.isClientSide) {
                p_220124_.startUsingItem(p_220125_);
                this.ApplyGlowingNew(p_220123_, p_220124_);
                if (p_220123_ instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)p_220123_;
                    Vec3 vec3 = p_220124_.blockPosition().getCenter().add(0.0, 0.0, 0.0);
                    serverLevel.sendParticles((ParticleOptions)TTParticleRegistry.ILLUSION.get(), vec3.x, vec3.y, vec3.z, 1, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
                }
                p_220124_.awardStat(Stats.ITEM_USED.get((Object)this));
                p_220124_.getCooldowns().addCooldown($$3, 600);
                if (!p_220124_.getAbilities().instabuild) {
                    $$3.shrink(1);
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private void ApplyGlowingNew(Level level, Player player) {
        player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 120, 0));
        int COUNT = level.getRandom().nextIntBetweenInclusive(2, 4);
        int j = level.getEntitiesOfClass(IllusionEntity.class, player.getBoundingBox().inflate(32.0)).size();
        if (j < 1) {
            for (int i = 0; i < COUNT; ++i) {
                BlockPos blockpos = player.blockPosition().offset(-2 + level.random.nextInt(8), 2, -2 + level.random.nextInt(8));
                if (!level.getBlockState(blockpos).isAir() || !level.getBlockState(blockpos.above()).isAir()) continue;
                IllusionEntity bolt = new IllusionEntity(TTEntityRegistry.ILLUSION.get(), level);
                bolt.setLimitedLife(600);
                double d0 = player.getX() + (level.random.nextDouble() - 0.5) * 16.0;
                double d1 = player.getY() + (double)(level.random.nextInt(64) - 32);
                double d2 = player.getZ() + (level.random.nextDouble() - 0.5) * 16.0;
                player.randomTeleport(d0, d1, d2, false);
                bolt.moveTo(blockpos.getX(), blockpos.getY(), blockpos.getZ());
                level.addFreshEntity((Entity)bolt);
                level.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)bolt));
            }
        } else {
            level.playSound((Player)null, player.blockPosition(), SoundEvents.EVOKER_PREPARE_WOLOLO, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    private void ApplyGlowing(Level level, Player player) {
        ItemStack $$3 = player.getItemInHand(InteractionHand.MAIN_HAND);
        float RANGE = $$3.has(TTItemRegistry.ILLUSION_RANGE.get()) ? (float)((Integer)$$3.get(TTItemRegistry.ILLUSION_RANGE.get())).intValue() : 16.0f;
        List Entities = level.getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate((double)RANGE));
        for (Mob livingEntity : Entities) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 600, 1));
            if (Entities.size() <= 50 || !(player instanceof ServerPlayer)) continue;
            TTTriggers.HIGHLIGHT_50_TRIGGER.get().trigger((ServerPlayer)player, $$3);
        }
    }
}

