/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.items;

import com.belgie.tricky_trials.core.TTEntityRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;

public class MoolinArmorItem
extends Item {
    private final BodyType bodyType;

    public MoolinArmorItem(ArmorMaterial material, BodyType bodyType, Item.Properties properties) {
        super(material.animalProperties(properties, bodyType.allowedEntities));
        this.bodyType = bodyType;
    }

    public MoolinArmorItem(ArmorMaterial material, BodyType bodyType, Holder<SoundEvent> equipSound, boolean damageOnHurt, Item.Properties properties) {
        super(material.animalProperties(properties, equipSound, damageOnHurt, bodyType.allowedEntities));
        this.bodyType = bodyType;
    }

    public SoundEvent getBreakingSound() {
        return this.bodyType.breakingSound;
    }

    public static enum BodyType {
        EQUESTRIAN(SoundEvents.ITEM_BREAK, EntityType.HORSE),
        CANINE(SoundEvents.WOLF_ARMOR_BREAK, TTEntityRegistry.MOOLIN.get());

        final SoundEvent breakingSound;
        final HolderSet<EntityType<?>> allowedEntities;

        private BodyType(SoundEvent breakingSound, EntityType ... allowedEntities) {
            this.breakingSound = breakingSound;
            this.allowedEntities = HolderSet.direct(EntityType::builtInRegistryHolder, (Object[])allowedEntities);
        }
    }
}

