/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.items;

import com.belgie.tricky_trials.common.blockentity.OminousShooterBlockentity;
import com.belgie.tricky_trials.common.blocks.OminousShooter;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class SoulEssenceItem
extends Item {
    private static final List<SoulEssenceItem> MOD_EGGS = new ArrayList<SoulEssenceItem>();
    private static final Map<EntityType<? extends Mob>, SoulEssenceItem> TYPE_MAP = new IdentityHashMap<EntityType<? extends Mob>, SoulEssenceItem>();
    private final Supplier<? extends EntityType<? extends Mob>> typeSupplier;
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");
    public static int highlightColor;

    public SoulEssenceItem(Supplier<? extends EntityType<? extends Mob>> type, Item.Properties props) {
        super(props);
        this.typeSupplier = type;
        highlightColor = 0;
        MOD_EGGS.add(this);
    }

    public InteractionResult useOn(UseOnContext p_43223_) {
        Level level = p_43223_.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = p_43223_.getItemInHand();
        BlockPos blockpos = p_43223_.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockEntity var8 = level.getBlockEntity(blockpos);
        if (var8 instanceof OminousShooterBlockentity) {
            OminousShooterBlockentity spawner = (OminousShooterBlockentity)var8;
            if (!((Boolean)blockstate.getValue((Property)OminousShooter.POWERED)).booleanValue()) {
                EntityType<?> entitytype1 = this.getType(itemstack);
                spawner.setEntityId(entitytype1, level.getRandom());
                spawner.SpawnedEntities = 0;
                level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
                level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)OminousShooter.POWERED, (Comparable)Boolean.valueOf(true)), 3);
                level.gameEvent((Entity)p_43223_.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, blockpos);
                itemstack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_333372_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_333372_, p_41423_, p_41424_);
        p_41423_.add(CommonComponents.EMPTY);
        p_41423_.add((Component)Component.translatable((String)"item.tricky_trials.soul_essence_detail").withStyle(ChatFormatting.GRAY));
        p_41423_.add((Component)CommonComponents.space().append((Component)Component.translatable((String)this.getType(p_41421_).toString()).withStyle(ChatFormatting.BLUE)));
    }

    public boolean spawnsEntity(ItemStack p_331553_, EntityType<?> p_43232_) {
        return Objects.equals(this.getType(p_331553_), p_43232_);
    }

    public EntityType<?> getType(ItemStack p_334231_) {
        CustomData customdata = (CustomData)p_334231_.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return !customdata.isEmpty() ? customdata.read(ENTITY_TYPE_FIELD_CODEC).result().orElse(this.getDefaultType()) : this.getDefaultType();
    }

    @javax.annotation.Nullable
    public static SoulEssenceItem byId(@javax.annotation.Nullable EntityType<?> p_43214_) {
        return TYPE_MAP.get(p_43214_);
    }

    @Nullable
    public static SoulEssenceItem fromEntityType(@Nullable EntityType<?> type) {
        SoulEssenceItem ret = TYPE_MAP.get(type);
        return ret != null ? ret : SoulEssenceItem.byId(type);
    }

    protected EntityType<?> getDefaultType() {
        return this.typeSupplier.get();
    }
}

