/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.items;

import com.belgie.tricky_trials.core.TTItemRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TitaniumBatItem
extends Item {
    public TitaniumBatItem(Item.Properties p_43272_) {
        super(p_43272_.component(DataComponents.TOOL, (Object)TitaniumBatItem.createToolProperties()).component(TTItemRegistry.BAT_KNOCKBACK.get(), (Object)3));
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canAttackBlock(BlockState p_43291_, Level p_43292_, BlockPos p_43293_, Player p_43294_) {
        return !p_43294_.isCreative();
    }

    public boolean hurtEnemy(ItemStack p_43278_, LivingEntity p_43279_, LivingEntity p_43280_) {
        int RANGE = p_43278_.has(TTItemRegistry.BAT_KNOCKBACK.get()) ? (Integer)p_43278_.get(TTItemRegistry.BAT_KNOCKBACK.get()) : 3;
        TitaniumBatItem.strongKnockback(RANGE, p_43280_, (Entity)p_43279_);
        p_43278_.hurtAndBreak(1, p_43280_, EquipmentSlot.MAINHAND);
        return true;
    }

    public static void strongKnockback(int range, LivingEntity source, Entity p_33340_) {
        double d0 = p_33340_.getX() - source.getX();
        double d1 = p_33340_.getZ() - source.getZ();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.push(d0 / d2 * (double)range, 0.2, d1 / d2 * (double)range);
    }
}

