/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.menus;

import com.belgie.tricky_trials.common.menus.BookletInventory;
import com.belgie.tricky_trials.core.TTMenuRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BookletMenu
extends AbstractContainerMenu {
    private static final Map<Predicate<ItemStack>, String> INFORMATION = new HashMap<Predicate<ItemStack>, String>();
    private final BookletInventory ttinventory;

    public BookletMenu(int id, Inventory playerInventory, FriendlyByteBuf friendlyByteBuf) {
        this(id, playerInventory, new BookletInventory(playerInventory.player));
    }

    public BookletMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, new BookletInventory(playerInventory.player));
    }

    public BookletMenu(int id, Inventory playerInventory, BookletInventory infoInventory) {
        super(TTMenuRegistry.BOOKLET.get(), id);
        BookletMenu.checkContainerSize((Container)infoInventory, (int)1);
        this.ttinventory = infoInventory;
        infoInventory.setMenu(this);
        infoInventory.startOpen(playerInventory.player);
        this.addSlot(new Slot((Container)infoInventory, 0, 120, 87));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + k * 9 + 9, 48 + i1 * 18, 113 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 48 + l * 18, 171));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
        return null;
    }

    public void removed(Player player) {
        super.removed(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = this.ttinventory.getItem(0);
            if (!stack.isEmpty()) {
                if (player.isAlive() && !serverPlayer.hasDisconnected()) {
                    player.getInventory().placeItemBackInInventory(stack);
                } else {
                    player.drop(stack, false);
                }
                this.ttinventory.setItem(0, ItemStack.EMPTY);
            }
        }
        this.ttinventory.stopOpen(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getInfo(ItemStack stack) {
        for (Predicate<ItemStack> predicate : INFORMATION.keySet()) {
            if (!predicate.test(stack)) continue;
            return INFORMATION.get(predicate);
        }
        return "info." + String.valueOf(stack.getItemName());
    }
}

