/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.menus.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class BookletButton
extends Button {
    private static final ResourceLocation BUTTON_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"textures/gui/button.png");

    public BookletButton(Button.Builder builder) {
        super(builder.createNarration(DEFAULT_NARRATION));
        this.active = false;
    }

    public void onPress() {
        if (this.isActive()) {
            this.onPress.onPress((Button)this);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        guiGraphics.blitSprite(RenderType::guiTextured, BUTTON_TEXTURES, this.getX(), this.getY(), this.width / 2, this.height);
        guiGraphics.blitSprite(RenderType::guiTextured, BUTTON_TEXTURES, this.getX() + this.width / 2, this.getY(), this.width / 2, this.height);
        int color = this.getFGColor();
        guiGraphics.drawCenteredString(fontRenderer, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, color | 0xFF000000);
    }
}

