/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.menus.screen;

import com.belgie.tricky_trials.common.menus.BookletMenu;
import com.belgie.tricky_trials.common.menus.screen.BookletButton;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class BookletScreen
extends AbstractContainerScreen<BookletMenu> {
    private static final ResourceLocation TEXTURE_INFO_BOOK = ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"textures/gui/booklet.png");
    private final Map<Integer, List<FormattedCharSequence>> tabs = new HashMap<Integer, List<FormattedCharSequence>>();
    private BookletButton previousButton;
    private BookletButton nextButton;
    private int TabCount;
    private ItemStack lastStack;

    public BookletScreen(BookletMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 256;
        this.imageHeight = 199;
    }

    protected void init() {
        super.init();
        int xPos = (this.width - this.getXSize()) / 2;
        int yPos = (this.height - this.getYSize()) / 2;
        this.previousButton = (BookletButton)this.addRenderableWidget((GuiEventListener)new BookletButton(new Button.Builder((Component)Component.literal((String)"Back"), button -> {
            if (this.TabCount > 0) {
                --this.TabCount;
            }
        }).bounds(xPos + 90, yPos + 87, 28, 16)));
        this.nextButton = (BookletButton)this.addRenderableWidget((GuiEventListener)new BookletButton(new Button.Builder((Component)Component.literal((String)"Next"), button -> {
            if (this.TabCount < this.tabs.size() - 1) {
                ++this.TabCount;
            }
        }).bounds(xPos + 138, yPos + 87, 28, 16)));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        ItemStack itemStack = ((Slot)((BookletMenu)this.getMenu()).slots.get(0)).getItem();
        if (!itemStack.isEmpty()) {
            String entryKey = ((BookletMenu)this.getMenu()).getInfo(itemStack);
            MutableComponent No_Info = Component.literal((String)"If you think this item needs Info let us Know");
            if (I18n.exists((String)entryKey)) {
                MutableComponent entry = Component.translatable((String)entryKey);
                this.createPages((Component)entry);
                if (this.TabCount == 0) {
                    ChatFormatting data = ((Rarity)itemStack.get(DataComponents.RARITY)).color();
                    MutableComponent title = itemStack.getHoverName().plainCopy().withStyle(data);
                    this.createText(guiGraphics, this.font.split((FormattedText)title, 120), 60, 42);
                    this.createText(guiGraphics, this.tabs.get(0), 60, 56);
                } else {
                    this.createText(guiGraphics, this.tabs.get(this.TabCount), 60, 56);
                }
            } else {
                this.createText(guiGraphics, this.font.split((FormattedText)No_Info, 120), 60, 38);
            }
        }
        if (itemStack.isEmpty() || !itemStack.is(this.lastStack.getItem())) {
            this.tabs.clear();
            this.TabCount = 0;
        }
        this.previousButton.active = this.TabCount > 0;
        this.nextButton.active = this.TabCount < this.tabs.size() - 1;
        this.lastStack = itemStack;
    }

    private void createPages(Component loreEntry) {
        ArrayList formattedText = new ArrayList(this.font.split((FormattedText)loreEntry, 120));
        if (formattedText.size() < 3) {
            List firstPage = formattedText.subList(0, formattedText.size());
            this.tabs.put(0, firstPage);
        } else {
            List firstPage = formattedText.subList(0, 3);
            this.tabs.put(0, firstPage);
            List remainingPages = formattedText.subList(3, formattedText.size());
            List list = Lists.partition(remainingPages, (int)3);
            for (int i = 1; i < list.size() + 1; ++i) {
                this.tabs.put(i, (List)list.get(i - 1));
            }
        }
    }

    private void createText(GuiGraphics guiGraphics, List<FormattedCharSequence> reorderingProcessors, int x, int y) {
        int length = 0;
        for (FormattedCharSequence line : reorderingProcessors) {
            this.drawBookText(guiGraphics, this.font, line, x, y + length * 10);
            ++length;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        int xPos = (this.width - this.getXSize()) / 2;
        int yPos = (this.height - this.getYSize()) / 2;
        guiGraphics.blit(RenderType::guiTextured, TEXTURE_INFO_BOOK, xPos + 12, yPos + 2, 0.0f, 0.0f, this.getXSize(), this.getYSize() + 56, 256, 256);
    }

    private void drawCenteredBookText(GuiGraphics guiGraphics, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.getVisualOrderText();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x - fontRenderer.width(sequence), y);
    }

    private void drawBookText(GuiGraphics guiGraphics, Font fontRenderer, FormattedCharSequence sequence, int x, int y) {
        guiGraphics.drawString(fontRenderer, sequence, x, y, 0x404040, false);
    }
}

