/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.particles;

import com.belgie.tricky_trials.common.entity.model.IllusionModel;
import com.belgie.tricky_trials.common.entity.renderer.IllusionRenderer;
import com.belgie.tricky_trials.utils.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IllusionParticle
extends Particle {
    private final Model model;
    private final RenderType renderType = RenderType.entityTranslucent((ResourceLocation)IllusionRenderer.TEXTURE_LOCATION);

    IllusionParticle(ClientLevel p_107114_, double p_107115_, double p_107116_, double p_107117_) {
        super(p_107114_, p_107115_, p_107116_, p_107117_);
        this.model = new IllusionModel(Minecraft.getInstance().getEntityModels().bakeLayer(ClientEntityRegistry.ILLUSION));
        this.gravity = 0.0f;
        this.lifetime = 30;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer p_107125_, Camera p_107126_, float p_107127_) {
        float $$3 = ((float)this.age + p_107127_) / (float)this.lifetime;
        float $$4 = 0.05f + 0.5f * Mth.sin((float)($$3 * (float)Math.PI));
        int $$5 = 1;
        PoseStack $$6 = new PoseStack();
        $$6.mulPose(p_107126_.rotation());
        $$6.mulPose(Axis.XP.rotationDegrees(150.0f * $$3 - 60.0f));
        $$6.scale(1.0f, -1.0f, -1.0f);
        $$6.translate(0.0f, -1.101f, 1.5f);
        MultiBufferSource.BufferSource $$7 = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer $$8 = $$7.getBuffer(this.renderType);
        this.model.renderToBuffer($$6, $$8, 0xF000F0, OverlayTexture.NO_OVERLAY, $$5);
        $$7.endBatch();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType p_107140_, ClientLevel p_107141_, double p_107142_, double p_107143_, double p_107144_, double p_107145_, double p_107146_, double p_107147_) {
            return new IllusionParticle(p_107141_, p_107142_, p_107143_, p_107144_);
        }
    }
}

