/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.core;

import com.belgie.tricky_trials.common.items.DreamingBottleItem;
import com.belgie.tricky_trials.common.items.EarthChargeItem;
import com.belgie.tricky_trials.common.items.EchoFlailItem;
import com.belgie.tricky_trials.common.items.HeavyArmorItem;
import com.belgie.tricky_trials.common.items.HeavyArmorTrimItem;
import com.belgie.tricky_trials.common.items.IllusionTotemItem;
import com.belgie.tricky_trials.common.items.MoolinArmorItem;
import com.belgie.tricky_trials.common.items.MysteryMapItem;
import com.belgie.tricky_trials.common.items.PowerHammerItem;
import com.belgie.tricky_trials.common.items.RedstoneWrenchItem;
import com.belgie.tricky_trials.common.items.RemoveStunnedItem;
import com.belgie.tricky_trials.common.items.ScrollItem;
import com.belgie.tricky_trials.common.items.SoulEssenceItem;
import com.belgie.tricky_trials.common.items.TitaniumBatItem;
import com.belgie.tricky_trials.common.items.WaterChargeItem;
import com.belgie.tricky_trials.common.items.components.DreamingBottleAmplifier;
import com.belgie.tricky_trials.core.TTBlockRegistry;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.belgie.tricky_trials.core.TTResourceKeys;
import com.belgie.tricky_trials.utils.TTArmorMaterials;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.equipment.ArmorType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TTItemRegistry {
    public static DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"tricky_trials");
    public static DeferredRegister<DataComponentType<?>> DATA = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"tricky_trials");
    public static final Supplier<DataComponentType<Integer>> FLAIL_RANGE = TTItemRegistry.register("flail_range", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
    public static final Supplier<DataComponentType<Integer>> ILLUSION_RANGE = TTItemRegistry.register("illusion_range", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
    public static final Supplier<DataComponentType<Integer>> BAT_KNOCKBACK = TTItemRegistry.register("bat_knockback", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
    public static final Supplier<DataComponentType<Integer>> HAMMER_RANGE = TTItemRegistry.register("hammer_range", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
    public static final Supplier<DataComponentType<DreamingBottleAmplifier>> DREAMING_BOTTLE_AMPLIFIER = TTItemRegistry.register("dreaming_bottle_amplifier", p_358136_ -> p_358136_.persistent(DreamingBottleAmplifier.CODEC).networkSynchronized(DreamingBottleAmplifier.STREAM_CODEC));
    public static final Supplier<Item> WOODLAND_KEY = ITEMS.register("woodland_key", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"woodland_key")))));
    public static final Supplier<Item> ECHO_KEY = ITEMS.register("echo_key", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"echo_key")))));
    public static final Supplier<Item> CITY_KEY = ITEMS.register("city_key", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"city_key")))));
    public static final Supplier<Item> BASTION_KEY = ITEMS.register("bastion_key", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"bastion_key")))));
    public static final Supplier<Item> TRICKY_KEY = ITEMS.register("tricky_key", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"tricky_key")))));
    public static final Supplier<Item> OMINOUS_TRICKY_KEY = ITEMS.register("ominous_tricky_key", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"ominous_tricky_key")))));
    public static final Supplier<Item> ELDER_KEY = ITEMS.register("elder_key", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"elder_key")))));
    public static final Supplier<Item> HEAVY_SCRAP = ITEMS.register("heavy_scrap", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"heavy_scrap")))));
    public static final Supplier<Item> HEAVY_GEM = ITEMS.register("heavy_gem", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"heavy_gem")))));
    public static final Supplier<Item> RAW_TITANIUM = ITEMS.register("raw_titanium", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"raw_titanium")))));
    public static final Supplier<Item> TITANIUM_INGOT = ITEMS.register("titanium_ingot", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"titanium_ingot")))));
    public static final Supplier<Item> MOOLIN_ARMOR = ITEMS.register("moolin_armor", () -> new MoolinArmorItem(TTArmorMaterials.TITANIUM, MoolinArmorItem.BodyType.CANINE, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"moolin_armor")))));
    public static final Supplier<Item> HEAVY_HELMET = ITEMS.register("heavy_helmet", () -> new HeavyArmorItem(TTArmorMaterials.HEAVY, ArmorType.HELMET, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"heavy_helmet"))).durability(ArmorType.HELMET.getDurability(15))));
    public static final Supplier<Item> HEAVY_CHESTPLATE = ITEMS.register("heavy_chestplate", () -> new HeavyArmorItem(TTArmorMaterials.HEAVY, ArmorType.CHESTPLATE, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"heavy_chestplate"))).durability(ArmorType.CHESTPLATE.getDurability(15))));
    public static final Supplier<Item> HEAVY_LEGGINGS = ITEMS.register("heavy_leggings", () -> new HeavyArmorItem(TTArmorMaterials.HEAVY, ArmorType.LEGGINGS, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"heavy_leggings"))).durability(ArmorType.LEGGINGS.getDurability(15))));
    public static final Supplier<Item> HEAVY_BOOTS = ITEMS.register("heavy_boots", () -> new HeavyArmorItem(TTArmorMaterials.HEAVY, ArmorType.BOOTS, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"heavy_boots"))).durability(ArmorType.BOOTS.getDurability(15))));
    public static final Supplier<Item> HEAVY_UPGRADE_SMITHING_TEMPLATE = ITEMS.register("heavy_upgrade_smithing_template", () -> HeavyArmorTrimItem.createHeavyUpgradeTemplate(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"heavy_upgrade_smithing_template"))).rarity(Rarity.EPIC)));
    public static final Supplier<Item> HEAVY_ARMOR_TRIM_SMITHING_TEMPLATE = ITEMS.register("heavy_armor_trim_smithing_template", () -> SmithingTemplateItem.createArmorTrimTemplate((Item.Properties)new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"heavy_armor_trim_smithing_template"))).rarity(Rarity.EPIC)));
    public static final Supplier<Item> OMEN_ARMOR_TRIM_SMITHING_TEMPLATE = ITEMS.register("omen_armor_trim_smithing_template", () -> SmithingTemplateItem.createArmorTrimTemplate((Item.Properties)new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"omen_armor_trim_smithing_template"))).rarity(Rarity.EPIC)));
    public static final Supplier<Item> ELDER_ARMOR_TRIM_SMITHING_TEMPLATE = ITEMS.register("elder_armor_trim_smithing_template", () -> SmithingTemplateItem.createArmorTrimTemplate((Item.Properties)new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"elder_armor_trim_smithing_template"))).rarity(Rarity.EPIC)));
    public static final Supplier<Item> VILER_POTTERY_SHERD = ITEMS.register("viler_pottery_sherd", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"viler_pottery_sherd")))));
    public static final Supplier<Item> INFESTED_POTTERY_SHERD = ITEMS.register("infested_pottery_sherd", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"infested_pottery_sherd")))));
    public static final Supplier<Item> COMMON_RARITY_SCROLL = ITEMS.register("common_rarity_scroll", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"common_rarity_scroll"))).stacksTo(1)));
    public static final Supplier<Item> UNCOMMON_RARITY_SCROLL = ITEMS.register("uncommon_rarity_scroll", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"uncommon_rarity_scroll"))).stacksTo(1)));
    public static final Supplier<Item> RARE_RARITY_SCROLL = ITEMS.register("rare_rarity_scroll", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"rare_rarity_scroll"))).stacksTo(1)));
    public static final Supplier<Item> EPIC_RARITY_SCROLL = ITEMS.register("epic_rarity_scroll", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"epic_rarity_scroll"))).stacksTo(1)));
    public static final Supplier<Item> ENCHANTMENT_GLINT_SCROLL = ITEMS.register("enchantment_glint_scroll", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"enchantment_glint_scroll"))).stacksTo(1).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true)));
    public static final Supplier<Item> UNBREAKABLE_SCROLL = ITEMS.register("unbreakable_scroll", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"unbreakable_scroll"))).stacksTo(1)));
    public static final Supplier<Item> FIRE_RESISTANCE_UPGRADE = ITEMS.register("fire_resistance_upgrade", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"fire_resistance_upgrade"))).stacksTo(1)));
    public static final Supplier<Item> EXPLOSION_RESISTANCE_UPGRADE = ITEMS.register("explosion_resistance_scroll", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"explosion_resistance_scroll"))).stacksTo(1)));
    public static final Supplier<Item> FANCY_TOOLTIP_UPGRADE = ITEMS.register("fancy_tooltip_scroll", () -> new ScrollItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"fancy_tooltip_scroll"))).stacksTo(1)));
    public static final Supplier<Item> REDSTONE_HEART = ITEMS.register("beast_heart", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"beast_heart")))));
    public static final Supplier<Item> COPPER_WIRE = ITEMS.register("copper_wire", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"copper_wire")))));
    public static final Supplier<Item> TRIAL_SHARD = ITEMS.register("trial_shard", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"trial_shard")))));
    public static final Supplier<Item> MYSTERY_MAP = ITEMS.register("mystery_map", () -> new MysteryMapItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"mystery_map")))));
    public static final FoodProperties STEW = TTItemRegistry.stew(4).build();
    public static final Supplier<Item> BAMBOO_STEW = ITEMS.register("bamboo_stew", () -> new RemoveStunnedItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"bamboo_stew"))).food(STEW).stacksTo(1)));
    public static final Supplier<Item> ILLUSION_TOTEM = ITEMS.register("totem_of_illusion", () -> new IllusionTotemItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"totem_of_illusion"))).stacksTo(1)));
    public static final Supplier<Item> WATER_CHARGE = ITEMS.register("water_charge", () -> new WaterChargeItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"water_charge")))));
    public static final Supplier<Item> EARTH_CHARGE = ITEMS.register("earth_charge", () -> new EarthChargeItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"earth_charge")))));
    public static final Supplier<Item> BLITZZE_ROD = ITEMS.register("bubblze_rod", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"bubblze_rod")))));
    public static final Supplier<Item> WRENCH = ITEMS.register("wrench", () -> new RedstoneWrenchItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"wrench"))).durability(64)));
    public static final Supplier<Item> TITANIUM_BAT = ITEMS.register("titanium_bat", () -> new TitaniumBatItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"titanium_bat"))).repairable(TITANIUM_INGOT.get()).durability(128).attributes(TitaniumBatItem.createAttributes()).component(DataComponents.RARITY, (Object)Rarity.UNCOMMON)));
    public static final Consumable DREAMING_BOTTLE_FOOD = Consumables.defaultDrink().soundAfterConsume((Holder)SoundEvents.OMINOUS_BOTTLE_DISPOSE).build();
    public static final Supplier<Item> DREAMING_BOTTLE = ITEMS.register("dreaming_bottle", () -> new DreamingBottleItem(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"dreaming_bottle"))).component(DataComponents.CONSUMABLE, (Object)DREAMING_BOTTLE_FOOD).component(DREAMING_BOTTLE_AMPLIFIER.get(), (Object)new DreamingBottleAmplifier(0))));
    public static final Supplier<Item> ECHO_FLAIL = ITEMS.register("echo_flail", () -> new EchoFlailItem(ToolMaterial.DIAMOND, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"echo_flail"))).attributes(EchoFlailItem.createAttributes()).component(DataComponents.RARITY, (Object)Rarity.EPIC)));
    public static final Supplier<Item> POWER_HAMMER = ITEMS.register("power_hammer", () -> new PowerHammerItem(ToolMaterial.DIAMOND, 0.1f, 0.1f, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"power_hammer"))).component(DataComponents.RARITY, (Object)Rarity.EPIC).component(HAMMER_RANGE.get(), (Object)1)));
    public static final Supplier<Item> LOCK_PICK = ITEMS.register("lock_pick", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"lock_pick")))));
    public static final Supplier<Item> MUSIC_DISC_VENTUROUS = ITEMS.register("music_disc_venturous", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"music_disc_venturous"))).stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(TTResourceKeys.VENTUROUS)));
    public static final Supplier<Item> TRIAL_KNIGHT_SPAWN_EGG = ITEMS.register("trial_knight_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.HEAVY_CORE_BOSS.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"trial_knight_spawn_egg")))));
    public static final Supplier<Item> BUBZE_SPAWN_EGG = ITEMS.register("bubblze_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.BUBZE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"bubblze_spawn_egg")))));
    public static final Supplier<Item> BLITZE_SPAWN_EGG = ITEMS.register("blitze_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.BLITZE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"blitze_spawn_egg")))));
    public static final Supplier<Item> BOULDERING_ZOMBIE_SPAWN_EGG = ITEMS.register("bouldering_zombie_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.BOULDERING_ZOMBIE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"bouldering_zombie_spawn_egg")))));
    public static final Supplier<Item> LOBBER_SPAWN_EGG = ITEMS.register("lobber_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.LOBBER_ZOMBIE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"lobber_spawn_egg")))));
    public static final Supplier<Item> VILER_WITCH_SPAWN_EGG = ITEMS.register("viler_witch_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.VILER_WITCH.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"viler_witch_spawn_egg")))));
    public static final Supplier<Item> PARASITE_SPAWN_EGG = ITEMS.register("bristle_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.PARASITE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"bristle_spawn_egg")))));
    public static final Supplier<Item> MOOLIN_SPAWN_EGG = ITEMS.register("moolin_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.MOOLIN.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"moolin_spawn_egg")))));
    public static final Supplier<Item> MOOLIN_BEAST_SPAWN_EGG = ITEMS.register("redstone_beast_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.REDSTONE_BEAST.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"redstone_beast_spawn_egg")))));
    public static final Supplier<Item> GRUNTER_SPAWN_EGG = ITEMS.register("grunter_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.GRUNT.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"grunter_spawn_egg")))));
    public static final Supplier<Item> STEALTH_SPAWN_EGG = ITEMS.register("stealth_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.STEALTH.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"stealth_spawn_egg")))));
    public static final Supplier<Item> COPPER_GOLEM_SPAWN_EGG = ITEMS.register("copper_golem_spawn_egg", () -> new SpawnEggItem(TTEntityRegistry.COPPER_GOLEM.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"copper_golem_spawn_egg")))));
    public static final Supplier<Item> MOB_ESSENCE_ZOMBIE = TTItemRegistry.register("soul_essence_zombie", () -> EntityType.ZOMBIE);
    public static final Supplier<Item> MOB_ESSENCE_HUSK = TTItemRegistry.register("soul_essence_husk", () -> EntityType.HUSK);
    public static final Supplier<Item> MOB_ESSENCE_BOGGED = TTItemRegistry.register("soul_essence_bogged", () -> EntityType.BOGGED);
    public static final Supplier<Item> MOB_ESSENCE_BREEZE = TTItemRegistry.register("soul_essence_breeze", () -> EntityType.BREEZE);
    public static final Supplier<Item> MOB_ESSENCE_CREEPER = TTItemRegistry.register("soul_essence_creeper", () -> EntityType.CREEPER);
    public static final Supplier<Item> MOB_ESSENCE_EVOKER = TTItemRegistry.register("soul_essence_evoker", () -> EntityType.EVOKER);
    public static final Supplier<Item> MOB_ESSENCE_PILLAGER = TTItemRegistry.register("soul_essence_pillager", () -> EntityType.PILLAGER);
    public static final Supplier<Item> MOB_ESSENCE_SKELETON = TTItemRegistry.register("soul_essence_skeleton", () -> EntityType.SKELETON);
    public static final Supplier<Item> MOB_ESSENCE_SLIME = TTItemRegistry.register("soul_essence_slime", () -> EntityType.SLIME);
    public static final Supplier<Item> MOB_ESSENCE_STRAY = TTItemRegistry.register("soul_essence_stray", () -> EntityType.STRAY);
    public static final Supplier<Item> MOB_ESSENCE_VINDICATOR = TTItemRegistry.register("soul_essence_vindicator", () -> EntityType.VINDICATOR);
    public static final Supplier<Item> MOB_ESSENCE_WITCH = TTItemRegistry.register("soul_essence_witch", () -> EntityType.WITCH);
    public static final Supplier<Item> MOB_ESSENCE_SPIDER = TTItemRegistry.register("soul_essence_spider", () -> EntityType.SPIDER);
    public static final Supplier<Item> MOB_ESSENCE_CAVE_SPIDER = TTItemRegistry.register("soul_essence_cave_spider", () -> EntityType.CAVE_SPIDER);
    public static final Supplier<Item> MOB_ESSENCE_ENDERMAN = TTItemRegistry.register("soul_essence_enderman", () -> EntityType.ENDERMAN);
    public static final Supplier<Item> MOB_ESSENCE_DROWNED = TTItemRegistry.register("soul_essence_drowned", () -> EntityType.DROWNED);
    public static final Supplier<Item> MOB_ESSENCE_VILER_WITCH = TTItemRegistry.register("soul_essence_viler_witch", () -> TTEntityRegistry.VILER_WITCH.get());
    public static final Supplier<Item> MOB_ESSENCE_BLITZE = TTItemRegistry.register("soul_essence_blitze", () -> TTEntityRegistry.BLITZE.get());
    public static final Supplier<Item> MOB_ESSENCE_BOULDERING_ZOMBIE = TTItemRegistry.register("soul_essence_bouldering_zombie", () -> TTEntityRegistry.BOULDERING_ZOMBIE.get());
    public static final Supplier<Item> MOB_ESSENCE_LOBBER = TTItemRegistry.register("soul_essence_lobber", () -> TTEntityRegistry.LOBBER_ZOMBIE.get());
    public static final Supplier<Item> MOB_ESSENCE_PARASITE = TTItemRegistry.register("soul_essence_bristle", () -> TTEntityRegistry.PARASITE.get());
    public static final Supplier<Item> SONIC_CORE = ITEMS.register("sonic_core", () -> new BlockItem(TTBlockRegistry.SONIC_CORE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"sonic_core"))).component(DataComponents.RARITY, (Object)Rarity.EPIC)));
    public static final Supplier<Item> OMINOUS_SHOOTER = ITEMS.register("ominous_cage", () -> new BlockItem(TTBlockRegistry.OMINOUS_SHOOTER.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"ominous_cage"))).component(DataComponents.RARITY, (Object)Rarity.EPIC)));
    public static final Supplier<Item> REDSTONE_CORE = ITEMS.register("redstone_core", () -> new BlockItem(TTBlockRegistry.REDSTONE_CORE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"redstone_core"))).component(DataComponents.RARITY, (Object)Rarity.EPIC)));
    public static final Supplier<Item> LABYRINTH_CURSE = ITEMS.register("labyrinth_curse", () -> new BlockItem(TTBlockRegistry.LABYRINTH_CURSE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"labyrinth_curse"))).component(DataComponents.RARITY, (Object)Rarity.EPIC)));

    private static <T> Supplier<DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return DATA.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    private static FoodProperties.Builder stew(int p_150384_) {
        return new FoodProperties.Builder().nutrition(p_150384_).saturationModifier(0.2f).alwaysEdible();
    }

    private static Supplier<Item> register(String name, Supplier<? extends EntityType<? extends Mob>> type) {
        DeferredHolder I = ITEMS.register(name, () -> new SoulEssenceItem(type, new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)name)))));
        return I;
    }
}

