/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.utils;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber(modid="tricky_trials")
public class AddHeavyCoreTrialRoom {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"));

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder emptyProcessorList = (Holder)processorListRegistry.get(EMPTY_PROCESSOR_LIST_KEY).orElseThrow();
        StructureTemplatePool pool = (StructureTemplatePool)((Holder.Reference)templatePoolRegistry.get(poolRL).orElseThrow()).value();
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.legacy((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    @SubscribeEvent
    public static void registerJigsaws(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().registryAccess().lookup(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().registryAccess().lookup(Registries.PROCESSOR_LIST).orElseThrow();
        ResourceLocation plainsPoolLocation = ResourceLocation.withDefaultNamespace((String)"trial_chambers/hallway");
        ResourceLocation decorLocation = ResourceLocation.withDefaultNamespace((String)"trial_chambers/decor");
        AddHeavyCoreTrialRoom.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "tricky_trials:knight", 200);
        AddHeavyCoreTrialRoom.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, decorLocation, "tricky_trials:copper_golem", 2);
    }
}

