/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.utils;

import com.belgie.tricky_trials.common.blockentity.ModVaultBlockentity;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultState;
import com.belgie.tricky_trials.common.blocks.ModVaultBlock;
import com.belgie.tricky_trials.common.entity.GrunterEntity;
import com.belgie.tricky_trials.common.entity.IllusionEntity;
import com.belgie.tricky_trials.common.entity.MoolinEntity;
import com.belgie.tricky_trials.common.entity.ThrownFireCharge;
import com.belgie.tricky_trials.common.items.PowerHammerItem;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.belgie.tricky_trials.core.TTItemRegistry;
import com.belgie.tricky_trials.core.TTMobEffects;
import com.belgie.tricky_trials.core.TTTagsRegistry;
import com.belgie.tricky_trials.utils.TTBrewingRecipes;
import com.belgie.tricky_trials.utils.TTResourceKeys;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSpawnPhantomsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class Events {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    public static void Join(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Monster) {
            Monster zombie = (Monster)entity;
            zombie.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)zombie, IllusionEntity.class, 5, false, false, (p, p_359165_) -> Events.isAngryAt(p)));
        }
    }

    public static boolean isAngryAt(LivingEntity p_21675_) {
        if (p_21675_ instanceof IllusionEntity) {
            IllusionEntity peng = (IllusionEntity)p_21675_;
            return peng.isAlive();
        }
        return false;
    }

    public static void HammerBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof PowerHammerItem) {
            PowerHammerItem hammer = (PowerHammerItem)item;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos initialBlockPos = event.getPos();
                if (HARVESTED_BLOCKS.contains(initialBlockPos)) {
                    return;
                }
                Optional $$2 = ((Registry)event.getPlayer().level().registryAccess().lookup(Registries.ENCHANTMENT).get()).get(TTResourceKeys.BOULDERING);
                Holder $$3 = (Holder)$$2.get();
                Optional voiding = ((Registry)event.getPlayer().level().registryAccess().lookup(Registries.ENCHANTMENT).get()).get(TTResourceKeys.VOIDING);
                Holder voiding_2 = (Holder)voiding.get();
                int RANGE = mainHandItem.has(TTItemRegistry.HAMMER_RANGE.get()) ? (Integer)mainHandItem.get(TTItemRegistry.HAMMER_RANGE.get()) : 1;
                int RANGE_2 = mainHandItem.getEnchantments().getLevel($$3);
                int RANGE_3 = RANGE + RANGE_2;
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                for (BlockPos pos : PowerHammerItem.getBlocksToBeDestroyed(RANGE_3, initialBlockPos, serverPlayer)) {
                    if (pos == initialBlockPos || !hammer.isCorrectToolForDrops(mainHandItem, event.getLevel().getBlockState(pos))) continue;
                    HARVESTED_BLOCKS.add(pos);
                    if (mainHandItem.getEnchantments().getLevel(voiding_2) > 0) {
                        Level level = serverPlayer.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel sl = (ServerLevel)level;
                            sl.destroyBlock(pos, false);
                        }
                    } else {
                        serverPlayer.gameMode.destroyBlock(pos);
                    }
                    HARVESTED_BLOCKS.remove(pos);
                }
            }
        }
    }

    public static void Brewing(RegisterBrewingRecipesEvent e) {
        e.getBuilder().addRecipe(Ingredient.of((ItemLike)PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.AWKWARD).getItem()), Ingredient.of((ItemLike)Items.CAMPFIRE), PotionContents.createItemStack((Item)Items.POTION, TTMobEffects.FIRE_CHARGE_POTION));
        e.getBuilder().addRecipe(Ingredient.of((ItemLike)PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.REGENERATION).getItem()), Ingredient.of((ItemLike)Items.FERMENTED_SPIDER_EYE), PotionContents.createItemStack((Item)Items.POTION, TTMobEffects.ROTTEN_POTION));
        e.getBuilder().addRecipe((IBrewingRecipe)new TTBrewingRecipes((Potion)Potions.WATER.value(), Items.PHANTOM_MEMBRANE, TTItemRegistry.DREAMING_BOTTLE.get()));
    }

    public static void Lightning(EntityStruckByLightningEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Cow) {
            MoolinEntity zombifiedpiglin;
            Cow cow = (Cow)entity;
            if (e.getEntity().level().getDifficulty() != Difficulty.PEACEFUL && EventHooks.canLivingConvert((LivingEntity)cow, TTEntityRegistry.MOOLIN.get(), timer -> {}) && (zombifiedpiglin = (MoolinEntity)TTEntityRegistry.MOOLIN.get().create(e.getEntity().level(), EntitySpawnReason.CONVERSION)) != null) {
                zombifiedpiglin.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TTItemRegistry.TITANIUM_BAT.get()));
                zombifiedpiglin.moveTo(cow.getX(), cow.getY(), cow.getZ(), cow.getYRot(), cow.getXRot());
                zombifiedpiglin.setNoAi(cow.isNoAi());
                zombifiedpiglin.setBaby(cow.isBaby());
                if (cow.hasCustomName()) {
                    zombifiedpiglin.setCustomName(cow.getCustomName());
                    zombifiedpiglin.setCustomNameVisible(cow.isCustomNameVisible());
                }
                zombifiedpiglin.setPersistenceRequired();
                EventHooks.onLivingConvert((LivingEntity)cow, (LivingEntity)zombifiedpiglin);
                cow.level().addFreshEntity((Entity)zombifiedpiglin);
                cow.discard();
            }
        }
    }

    public static void Painting(LivingHealEvent e) {
        if (e.getEntity().hasEffect(TTMobEffects.ROTTEN)) {
            e.setAmount(0.0f);
        }
    }

    public static void FOV(ComputeFovModifierEvent e) {
        if (e.getPlayer().hasEffect(TTMobEffects.STUNNED)) {
            e.setNewFovModifier(((Double)Minecraft.getInstance().options.fovEffectScale().get()).floatValue());
        }
    }

    public static void LabyrinthsCurseEvent(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().hasEffect(TTMobEffects.LABYRINTHS_CURSE) && event.getState().is(TTTagsRegistry.LABYRINTH_BLOCKS)) {
            event.setNewSpeed(0.0f);
        }
        if (event.getEntity().hasEffect(TTMobEffects.TREASURE_CURSE) && event.getState().is(TTTagsRegistry.TREASURE_ROOM_BLOCKS)) {
            event.setNewSpeed(0.0f);
        }
    }

    public static void PickLockBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack p_330793_ = event.getItemStack();
        BlockState p_331776_ = event.getLevel().getBlockState(event.getPos());
        Level p_335228_ = event.getLevel();
        BlockPos p_334682_ = event.getPos();
        Player p_334435_ = event.getEntity();
        InteractionHand p_332576_ = event.getHand();
        if (event.getItemStack().is(TTItemRegistry.LOCK_PICK.get())) {
            p_334435_.swing(p_332576_);
            if (p_335228_ instanceof ServerLevel) {
                ServerLevel $$8 = (ServerLevel)p_335228_;
                BlockEntity var10 = $$8.getBlockEntity(p_334682_);
                if (var10 instanceof VaultBlockEntity && p_331776_.getValue(VaultBlock.STATE) == VaultState.INACTIVE) {
                    VaultBlockEntity $$10 = (VaultBlockEntity)var10;
                    if ($$10.getServerData().rewardedPlayers.contains(p_334435_.getUUID())) {
                        $$10.getServerData().rewardedPlayers.remove(p_334435_.getUUID());
                        Events.SwingAndShrink(p_330793_, p_334435_);
                        p_335228_.levelEvent(3013, p_334682_, 4);
                        $$8.playSound((Player)null, p_334682_, SoundEvents.VAULT_REJECT_REWARDED_PLAYER, SoundSource.BLOCKS);
                    }
                } else if (var10 instanceof ModVaultBlockentity && p_331776_.getValue(ModVaultBlock.STATE) == ModVaultState.INACTIVE) {
                    ModVaultBlockentity $$10 = (ModVaultBlockentity)var10;
                    if ($$10.getServerData().rewardedPlayers.contains(p_334435_.getUUID())) {
                        $$10.getServerData().rewardedPlayers.remove(p_334435_.getUUID());
                        Events.SwingAndShrink(p_330793_, p_334435_);
                        p_335228_.levelEvent(3013, p_334682_, 4);
                        $$8.playSound((Player)null, p_334682_, SoundEvents.VAULT_REJECT_REWARDED_PLAYER, SoundSource.BLOCKS);
                    }
                } else if (var10 instanceof TrialSpawnerBlockEntity && p_331776_.getValue((Property)TrialSpawnerBlock.STATE) == TrialSpawnerState.COOLDOWN) {
                    TrialSpawnerBlockEntity $$10 = (TrialSpawnerBlockEntity)var10;
                    $$10.getTrialSpawner().getData().reset();
                    Events.SwingAndShrink(p_330793_, p_334435_);
                    p_335228_.levelEvent(3013, p_334682_, 4);
                    $$8.playSound((Player)null, p_334682_, SoundEvents.VAULT_REJECT_REWARDED_PLAYER, SoundSource.BLOCKS);
                }
            }
        }
    }

    public static void SwingAndShrink(ItemStack stack, Player player) {
        if (!player.isCreative()) {
            stack.shrink(1);
        }
    }

    public static void ThrowFireCharge(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().is(Items.FIRE_CHARGE)) {
            Events.use(event.getLevel(), event.getEntity(), event.getHand());
            event.getEntity().swing(event.getHand());
        }
    }

    public static InteractionResult use(Level p_333953_, Player p_328676_, InteractionHand p_332155_) {
        if (!p_333953_.isClientSide()) {
            ThrownFireCharge $$3 = new ThrownFireCharge(p_328676_, p_333953_, p_328676_.position().x(), p_328676_.getEyePosition().y(), p_328676_.position().z());
            $$3.shootFromRotation((Entity)p_328676_, p_328676_.getXRot(), p_328676_.getYRot(), 0.0f, 1.5f, 1.0f);
            p_333953_.addFreshEntity((Entity)$$3);
        }
        p_333953_.playSound((Player)null, p_328676_.getX(), p_328676_.getY(), p_328676_.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 0.5f, 0.4f / (p_333953_.getRandom().nextFloat() * 0.4f + 0.8f));
        ItemStack $$4 = p_328676_.getItemInHand(p_332155_);
        p_328676_.getCooldowns().addCooldown(p_328676_.getMainHandItem().getItem().getDefaultInstance(), 10);
        p_328676_.awardStat(Stats.ITEM_USED.get((Object)p_328676_.getMainHandItem().getItem()));
        $$4.consume(1, (LivingEntity)p_328676_);
        return InteractionResult.SUCCESS;
    }

    public static void FireRes(AnvilUpdateEvent event) {
        ItemStack TOBEResult;
        ItemStack LeftItem = event.getLeft();
        ItemStack RightItem = event.getRight();
        if (!LeftItem.has(DataComponents.DAMAGE_RESISTANT) && !LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.FIRE_RESISTANCE_UPGRADE.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(1L);
            TOBEResult.set(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_FIRE));
            TOBEResult.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"data.tricky_trials.fire_resistance")), List.of(Component.translatable((String)""))));
            event.setOutput(TOBEResult);
        }
        if (!LeftItem.has(DataComponents.DAMAGE_RESISTANT) && !LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.EXPLOSION_RESISTANCE_UPGRADE.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(1L);
            TOBEResult.set(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_EXPLOSION));
            TOBEResult.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"data.tricky_trials.explosion_resistance")), List.of(Component.translatable((String)""))));
            event.setOutput(TOBEResult);
        }
        if (!LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.COMMON_RARITY_SCROLL.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(1L);
            TOBEResult.set(DataComponents.RARITY, (Object)Rarity.COMMON);
            event.setOutput(TOBEResult);
        }
        if (!LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.FANCY_TOOLTIP_UPGRADE.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(1L);
            TOBEResult.set(DataComponents.TOOLTIP_STYLE, (Object)ResourceLocation.fromNamespaceAndPath((String)"tricky_trials", (String)"fancy"));
            event.setOutput(TOBEResult);
        }
        if (!LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.UNCOMMON_RARITY_SCROLL.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(1L);
            TOBEResult.set(DataComponents.RARITY, (Object)Rarity.UNCOMMON);
            event.setOutput(TOBEResult);
        }
        if (!LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.RARE_RARITY_SCROLL.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(1L);
            TOBEResult.set(DataComponents.RARITY, (Object)Rarity.RARE);
            event.setOutput(TOBEResult);
        }
        if (!LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.EPIC_RARITY_SCROLL.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(1L);
            TOBEResult.set(DataComponents.RARITY, (Object)Rarity.EPIC);
            event.setOutput(TOBEResult);
        }
        if (!LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.ENCHANTMENT_GLINT_SCROLL.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(1L);
            TOBEResult.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            event.setOutput(TOBEResult);
        }
        if (LeftItem.isDamageableItem() && !LeftItem.is(TTTagsRegistry.CAN_NOT_APPLY_SCROLLS_TO) && RightItem.is(TTItemRegistry.UNBREAKABLE_SCROLL.get())) {
            TOBEResult = LeftItem.copy();
            event.setCost(30L);
            Optional $$2 = ((Registry)event.getPlayer().level().registryAccess().lookup(Registries.ENCHANTMENT).get()).get(Enchantments.VANISHING_CURSE);
            Holder $$3 = (Holder)$$2.get();
            TOBEResult.enchant($$3, 1);
            TOBEResult.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
            event.setOutput(TOBEResult);
        }
    }

    public static void Phantom(PlayerSpawnPhantomsEvent event) {
        if (event.getEntity().hasEffect(TTMobEffects.DREAMING)) {
            event.setPhantomsToSpawn(0);
        }
    }

    public static void DropKeyEvent(LivingDropsEvent event) {
        GrunterEntity grunt;
        Mob warden;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Evoker) {
            Evoker E = (Evoker)livingEntity;
            if (event.getSource().is(DamageTypes.PLAYER_ATTACK)) {
                event.getDrops().clear();
                if (event.getEntity().level().getRandom().nextFloat() < 0.5f) {
                    event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)TTItemRegistry.WOODLAND_KEY.get())));
                }
            }
        }
        if (event.getEntity() instanceof Illusioner && event.getSource().is(DamageTypes.PLAYER_ATTACK) && event.getEntity().level().getRandom().nextFloat() < 0.25f) {
            event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)TTItemRegistry.ILLUSION_TOTEM.get())));
        }
        if ((livingEntity = event.getEntity()) instanceof Piglin) {
            Piglin p = (Piglin)livingEntity;
            if (event.getSource().is(DamageTypes.PLAYER_ATTACK) && event.getEntity().level().getRandom().nextFloat() < 0.25f && !p.isBaby()) {
                event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)TTItemRegistry.BASTION_KEY.get())));
            }
        }
        if (event.getEntity() instanceof Shulker && event.getSource().is(DamageTypes.PLAYER_ATTACK) && event.getEntity().level().getRandom().nextFloat() < 0.1f) {
            event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)TTItemRegistry.CITY_KEY.get())));
        }
        if ((livingEntity = event.getEntity()) instanceof Mob && (warden = (Mob)livingEntity).getSpawnType() == EntitySpawnReason.TRIAL_SPAWNER && event.getSource().is(DamageTypes.PLAYER_ATTACK) && event.getEntity().level().getRandom().nextFloat() < 0.1f) {
            ItemEntity entity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)TTItemRegistry.TRIAL_SHARD.get()));
            event.getEntity().level().addFreshEntity((Entity)entity);
        }
        if ((livingEntity = event.getEntity()) instanceof GrunterEntity && (grunt = (GrunterEntity)livingEntity).getSpawnType() == EntitySpawnReason.TRIAL_SPAWNER) {
            event.getDrops().clear();
        }
    }
}

