package com.startraveler;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

public class RestInPieces implements ModInitializer {
    public static final String MOD_ID = "rest-in-pieces";
    // This logger is used to write text to the console and the log file.
    // It is considered best practice to use your mod id as the logger's name.
    // That way, it's clear which mod wrote info, warnings, and errors.
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    public static final class_6862<class_1792> CLOTHS = class_6862.method_40092(class_7924.field_41197, RestInPieces.id("cloths"));
    private static final Optional<class_5321<class_52>> ZOMBIE_LOOT_TABLE = class_1299.field_6051.method_16351();
    private static final Optional<class_5321<class_52>> ZOMBIE_VILLAGER_LOOT_TABLE = class_1299.field_6054.method_16351();
    private static final Optional<class_5321<class_52>> HUSK_LOOT_TABLE = class_1299.field_6071.method_16351();
    private static final Optional<class_5321<class_52>> DROWNED_LOOT_TABLE = class_1299.field_6123.method_16351();

    public static void modifyZombieLootTable() {

        ZOMBIE_LOOT_TABLE.ifPresentOrElse(
                zombieLootTable -> LootTableEvents.MODIFY.register((key, lootTableBuilder, lootTableSource, wrapperLookup) -> {
                    if (zombieLootTable.equals(key)) {
                        class_55.class_56 poolBuilder = class_55.method_347()
                                .method_352(new class_44(1))
                                .method_351(class_77.method_411(class_1802.field_8162).method_437(2))
                                .method_351(class_77.method_411(RIPItems.BLUE_CLOTH).method_437(1));

                        lootTableBuilder.method_336(poolBuilder);
                    }
                }), () -> LOGGER.warn("Warning: could not locate Zombie loot table for mod {}", MOD_ID)
        );

        HUSK_LOOT_TABLE.ifPresentOrElse(
                zombieLootTable -> LootTableEvents.MODIFY.register((key, lootTableBuilder, lootTableSource, wrapperLookup) -> {
                    if (zombieLootTable.equals(key)) {
                        class_55.class_56 poolBuilder = class_55.method_347()
                                .method_352(new class_44(1))
                                .method_351(class_77.method_411(class_1802.field_8162).method_437(2))
                                .method_351(class_77.method_411(RIPItems.BROWN_CLOTH).method_437(1));

                        lootTableBuilder.method_336(poolBuilder);
                    }
                }), () -> LOGGER.warn("Warning: could not locate Husk loot table for mod {}", MOD_ID)
        );

        DROWNED_LOOT_TABLE.ifPresentOrElse(
                zombieLootTable -> LootTableEvents.MODIFY.register((key, lootTableBuilder, lootTableSource, wrapperLookup) -> {
                    if (zombieLootTable.equals(key)) {
                        class_55.class_56 poolBuilder = class_55.method_347()
                                .method_352(new class_44(1))
                                .method_351(class_77.method_411(class_1802.field_8162).method_437(2))
                                .method_351(class_77.method_411(RIPItems.CYAN_CLOTH).method_437(1));

                        lootTableBuilder.method_336(poolBuilder);
                    }
                }), () -> LOGGER.warn("Warning: could not locate Drowned loot table for mod {}", MOD_ID)
        );

        ZOMBIE_VILLAGER_LOOT_TABLE.ifPresentOrElse(
                zombieLootTable -> LootTableEvents.MODIFY.register((key, lootTableBuilder, lootTableSource, wrapperLookup) -> {
                    if (zombieLootTable.equals(key)) {
                        class_55.class_56 poolBuilder = class_55.method_347()
                                .method_352(new class_44(1))
                                .method_351(class_77.method_411(class_1802.field_8162).method_437(20))
                                .method_351(class_77.method_411(RIPItems.YELLOW_CLOTH).method_437(1))
                                .method_351(class_77.method_411(RIPItems.GREEN_CLOTH).method_437(1))
                                .method_351(class_77.method_411(RIPItems.LIGHT_GRAY_CLOTH).method_437(1))
                                .method_351(class_77.method_411(RIPItems.WHITE_CLOTH).method_437(1))
                                .method_351(class_77.method_411(RIPItems.RED_CLOTH).method_437(1))
                                .method_351(class_77.method_411(RIPItems.BROWN_CLOTH).method_437(5));

                        lootTableBuilder.method_336(poolBuilder);
                    }
                }), () -> LOGGER.warn("Warning: could not locate Zombie Villager loot table for mod {}", MOD_ID)
        );

    }

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static void addToItemGroups() {
        RIPItems.ITEMS.forEach(item -> ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062)
                .register((itemGroup) -> itemGroup.method_45421(item)));
    }

    @Override
    public void onInitialize() {
        // This code runs as soon as Minecraft is in a mod-load-ready state.
        // However, some things (like resources) may still be uninitialized.
        // Proceed with mild caution.
        RIPItems.onInitialize();
        RestInPieces.addToItemGroups();
        RestInPieces.modifyZombieLootTable();
    }

}