package com.startraveler.datagen;

import com.startraveler.RIPItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_7225;
import org.apache.commons.lang3.text.WordUtils;

import java.util.concurrent.CompletableFuture;

public class RIPEnglishNameProvider extends FabricLanguageProvider {
    public RIPEnglishNameProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        // Specifying en_us is optional, as it's the default language code
        super(dataOutput, "en_us", registryLookup);
    }

    @Override
    public void generateTranslations(class_7225.class_7874 wrapperLookup, TranslationBuilder translationBuilder) {
        RIPItems.ITEMS.forEach(item -> {
            translationBuilder.add(
                    item.method_7876(),
                    WordUtils.capitalize(item.method_40131()
                            .method_40237()
                            .method_29177()
                            .method_12832()
                            .replace('/', ' ')
                            .replace('_', ' '))
            );
        });
        translationBuilder.add("tag.item.rest-in-pieces.cloths", "Cloths");
    }

    @Override
    public String method_10321() {
        return "Rest in Pieces en_us Language Provider";
    }
}

