/*
 * Decompiled with CFR 0.152.
 */
package dev.knabbiii.feathertouch.listener;

import dev.knabbiii.feathertouch.FeatherTouchPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class FeatherDamageListener
implements Listener {
    private final FeatherTouchPlugin plugin;
    private final Map<UUID, Long> lastFeatherHit = new HashMap<UUID, Long>();
    private static final long FEATHER_COOLDOWN = 600L;

    public FeatherDamageListener(@NotNull FeatherTouchPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event) {
        if (!this.plugin.isPluginEnabled()) {
            return;
        }
        Entity damager = event.getDamager();
        if (!(damager instanceof Player)) {
            return;
        }
        Player player = (Player)damager;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType() != Material.FEATHER) {
            return;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastHit = this.lastFeatherHit.get(playerId);
        if (lastHit != null && currentTime - lastHit < 600L) {
            event.setCancelled(true);
            return;
        }
        this.lastFeatherHit.put(playerId, currentTime);
        event.setCancelled(true);
        Entity victim = event.getEntity();
        Vector direction = victim.getLocation().toVector().subtract(player.getLocation().toVector()).normalize().multiply(0.35).setY(0.15);
        victim.setVelocity(direction);
        if (this.plugin.isSoundEnabled()) {
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 0.5f, 1.5f);
        }
    }

    @NotNull
    public FeatherTouchPlugin getPlugin() {
        return this.plugin;
    }
}

