/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.effect;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityControlledZombie;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class EntityNecromancersHead
extends ThrowableProjectile
implements ItemSupplier {
    private static final int DURATION = 200;
    private static final ItemStack RENDER_ITEM = new ItemStack((ItemLike)Items.f_42678_);
    protected boolean observing = false;
    protected LivingEntity target = null;
    protected List<EntityControlledZombie> observables = Lists.newLinkedList();
    protected Class<? extends Mob> mobType = EntityControlledZombie.class;

    public EntityNecromancersHead(EntityType<? extends EntityNecromancersHead> type, Level world) {
        super(type, world);
    }

    public EntityNecromancersHead(Level world, LivingEntity entity) {
        super(RegistryEntries.ENTITY_NECROMANCER_HEAD, entity, world);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setMobType(Class<? extends Mob> mobType) {
        this.mobType = mobType;
    }

    protected void spawnSwarm(LivingEntity necromancer, LivingEntity target) {
        Level world = target.m_9236_();
        int amount = world.f_46441_.m_188503_(2) + 3;
        for (int i = 0; i < amount; ++i) {
            EntityControlledZombie mob = new EntityControlledZombie(world);
            if (!mob.m_6549_(target.m_6095_())) continue;
            mob.m_20359_((Entity)necromancer);
            mob.m_6478_(MoverType.SELF, new Vec3((double)(world.f_46441_.m_188503_(20) - 10), 0.0, (double)(world.f_46441_.m_188503_(20) - 10)));
            if (EntityHelpers.spawnEntity((ServerLevel)((ServerLevel)world), (Mob)mob, (MobSpawnType)MobSpawnType.MOB_SUMMONED)) {
                this.observables.add(mob);
            }
            mob.m_6710_(target);
            mob.setTtl(200);
        }
        this.target = target;
        this.setObserverMode();
        if (necromancer instanceof ServerPlayer) {
            Advancements.NECROMANCE.test((ServerPlayer)necromancer, (Entity)target);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.observing && !this.m_9236_().m_5776_() && WorldHelpers.efficientTick((Level)this.m_9236_(), (int)10, (int[])new int[0])) {
            if (!this.observables.isEmpty()) {
                Iterator<EntityControlledZombie> it = this.observables.iterator();
                while (it.hasNext()) {
                    EntityControlledZombie mob = it.next();
                    if (mob.m_6084_() && this.target.m_6084_()) continue;
                    if (mob.m_6084_()) {
                        mob.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                    it.remove();
                }
            }
            if (this.observables.isEmpty()) {
                this.observing = false;
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void m_8097_() {
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (!this.observing) {
            super.m_142687_(removalReason);
        }
    }

    protected void setObserverMode() {
        this.observing = true;
        this.m_20334_(0.0, 0.0, 0.0);
        this.m_6842_(true);
    }

    protected void m_6532_(HitResult position) {
        if (position.m_6662_() == HitResult.Type.ENTITY && !this.observing && !this.m_20193_().m_5776_()) {
            ((EntityHitResult)position).m_82443_().m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
            if (this.m_19749_() instanceof ServerPlayer && this.m_19749_() != ((EntityHitResult)position).m_82443_() && ((EntityHitResult)position).m_82443_() instanceof LivingEntity) {
                this.spawnSwarm((LivingEntity)this.m_19749_(), (LivingEntity)((EntityHitResult)position).m_82443_());
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public ItemStack m_7846_() {
        return RENDER_ITEM;
    }
}

