/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.spiritfurnace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSpiritFurnaceConfig;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator.SpiritReanimatorRecipeJEI;

public class SpiritFurnaceRecipeJEI {
    private final FluidStack inputFluid;
    private final ItemStack inputItem;
    private final List<ItemStack> outputItems;
    private final int duration;

    public SpiritFurnaceRecipeJEI(FluidStack inputFluid, ItemStack inputItem, List<ItemStack> outputItems, int duration) {
        this.inputFluid = inputFluid;
        this.inputItem = inputItem;
        this.outputItems = outputItems;
        this.duration = duration;
    }

    public static SpiritFurnaceRecipeJEI create(EntityType<?> entityType, LivingEntity entity, ServerLevel level) {
        int duration = SpiritFurnaceRecipeJEI.getRequiredTicks((Entity)entity);
        return new SpiritFurnaceRecipeJEI(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, duration * BlockSpiritFurnaceConfig.mBPerTick), SpiritReanimatorRecipeJEI.getBox(entityType), SpiritFurnaceRecipeJEI.getMobDrops(entityType, (Entity)entity, level), SpiritFurnaceRecipeJEI.getRequiredTicks((Entity)entity));
    }

    public static List<ItemStack> getMobDrops(EntityType<?> entityType, Entity entity, ServerLevel level) {
        ArrayList items = Lists.newArrayList();
        FakePlayer killerEntity = FakePlayerFactory.getMinecraft((ServerLevel)level);
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)Vec3.f_82478_).m_287286_(LootContextParams.f_81458_, (Object)killerEntity).m_287286_(LootContextParams.f_81459_, (Object)killerEntity).m_287286_(LootContextParams.f_81457_, (Object)killerEntity.m_269291_().m_269264_());
        LootParams params = lootParamsBuilder.m_287235_(LootContextParamSets.f_81415_);
        LootContext context = new LootContext.Builder(params).m_287259_(entityType.m_20677_());
        LootTable lootTable = ServerLifecycleHooks.getCurrentServer().m_278653_().m_278676_(entityType.m_20677_());
        for (LootPool pool : lootTable.f_79109_) {
            for (LootPoolEntryContainer entryContainer : pool.f_79023_) {
                entryContainer.m_6562_(context, entry -> entry.m_6941_(items::add, context));
            }
        }
        return items;
    }

    public static int getRequiredTicks(Entity entity) {
        int requiredTicksBase;
        try {
            LivingEntity livingEntity = (LivingEntity)entity;
            requiredTicksBase = (int)((livingEntity.m_21223_() + (float)livingEntity.m_21230_()) * (float)BlockSpiritFurnaceConfig.requiredTicksPerHp);
        }
        catch (RuntimeException var7) {
            requiredTicksBase = 40 * BlockSpiritFurnaceConfig.requiredTicksPerHp;
        }
        return requiredTicksBase;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getInputItem() {
        return this.inputItem;
    }

    public List<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public int getDuration() {
        return this.duration;
    }

    public static void encode(SpiritFurnaceRecipeJEI recipe, FriendlyByteBuf output) {
        output.writeFluidStack(recipe.getInputFluid());
        output.m_130055_(recipe.inputItem);
        output.writeInt(recipe.outputItems.size());
        for (ItemStack outputItem : recipe.outputItems) {
            output.m_130055_(outputItem);
        }
        output.writeInt(recipe.duration);
    }

    public static SpiritFurnaceRecipeJEI decode(FriendlyByteBuf input) {
        FluidStack inputFluid = input.readFluidStack();
        ItemStack inputItem = input.m_130267_();
        ArrayList outputItems = Lists.newArrayList();
        int outputItemsCount = input.readInt();
        for (int i = 0; i < outputItemsCount; ++i) {
            outputItems.add(input.m_130267_());
        }
        int duration = input.readInt();
        return new SpiritFurnaceRecipeJEI(inputFluid, inputItem, outputItems, duration);
    }

    public static List<SpiritFurnaceRecipeJEI> generateServerRecipes() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129783_();
        ArrayList recipes = Lists.newArrayList();
        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
            try {
                LivingEntity livingEntity;
                Entity entity = entityType.m_20615_((Level)level);
                if (!(entity instanceof LivingEntity) || !EntityVengeanceSpirit.canSustain(livingEntity = (LivingEntity)entity)) continue;
                recipes.add(SpiritFurnaceRecipeJEI.create(entityType, livingEntity, level));
            }
            catch (RuntimeException runtimeException) {}
        }
        return recipes;
    }
}

