/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.evilcraft.ExtendedDamageSources;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritPortal;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;

public class BlockSpiritPortal
extends BlockWithEntity {
    public static final MapCodec<BlockSpiritPortal> CODEC = BlockSpiritPortal.simpleCodec(BlockSpiritPortal::new);
    public static final VoxelShape SHAPE = Block.box((double)6.4f, (double)6.4f, (double)6.4f, (double)9.6f, (double)9.6f, (double)9.6f);

    public BlockSpiritPortal(BlockBehaviour.Properties properties) {
        super(properties, BlockEntitySpiritPortal::new);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockSpiritPortal.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SPIRIT_PORTAL.get()), (BlockEntityTicker)new BlockEntitySpiritPortal.Ticker());
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    protected static boolean canReplaceBlock(BlockState blockState, LevelReader world, BlockPos pos) {
        return blockState != null && (blockState.isAir() || blockState.canBeReplaced());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void palingDeath(LivingDeathEvent event) {
        if (event.getSource().type().equals(event.getEntity().level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ExtendedDamageSources.DAMAGE_TYPE_PALING).value())) {
            this.tryPlacePortal(event.getEntity().level(), event.getEntity().blockPosition().offset(0, 1, 0));
        }
    }

    public boolean tryPlacePortal(Level world, BlockPos blockPos) {
        RegionIterator it = new RegionIterator(blockPos, 1, true);
        for (int attempts = 9; it.hasNext() && attempts >= 0; --attempts) {
            BlockPos location = it.next();
            if (!BlockSpiritPortal.canReplaceBlock(world.getBlockState(location), (LevelReader)world, blockPos)) continue;
            world.setBlock(location, ((Block)RegistryEntries.BLOCK_SPIRIT_PORTAL.get()).defaultBlockState(), 3);
            return true;
        }
        return false;
    }
}

