/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.client.model.DelegatingChildDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkTank;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;
import org.jetbrains.annotations.NotNull;

public class ModelDarkTankBaked
extends DelegatingChildDynamicItemAndBlockModel {
    private final int capacity;
    private final FluidStack fluidStack;

    public ModelDarkTankBaked(BakedModel baseModel) {
        super(baseModel);
        this.capacity = 0;
        this.fluidStack = null;
    }

    public ModelDarkTankBaked(BakedModel baseModel, int capacity, FluidStack fluidStack, BlockState blockState, Direction facing, RandomSource rand, ModelData modelData, RenderType renderType) {
        super(baseModel, blockState, facing, rand, modelData, renderType);
        this.capacity = capacity;
        this.fluidStack = fluidStack;
    }

    public ModelDarkTankBaked(BakedModel baseModel, int capacity, FluidStack fluidStack, ItemStack itemStack, Level world, LivingEntity entity) {
        super(baseModel, itemStack, world, entity);
        this.capacity = capacity;
        this.fluidStack = fluidStack;
    }

    public List<BakedQuad> getGeneralQuads() {
        ArrayList combinedList = Lists.newArrayList();
        if (this.fluidStack != null && !this.fluidStack.isEmpty() && (BlockDarkTankConfig.staticBlockRendering || this.isItemStack())) {
            boolean flowing = this.isItemStack() && ((BlockDarkTank)RegistryEntries.BLOCK_DARK_TANK.get()).isActivated(this.itemStack, Item.TooltipContext.of((Level)this.world));
            combinedList.addAll(this.getFluidQuads(this.fluidStack, this.capacity, flowing));
        }
        combinedList.addAll(this.baseModel.getQuads(this.blockState, this.getRenderingSide(), this.rand));
        return combinedList;
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityDarkTank.class).map(tile -> {
            ModelData.Builder builder = ModelData.builder();
            builder.with(BlockDarkTank.TANK_FLUID, (Object)tile.getTank().getFluid());
            builder.with(BlockDarkTank.TANK_CAPACITY, (Object)tile.getTank().getCapacity());
            return builder.build();
        }).orElse(ModelData.EMPTY);
    }

    public BakedModel handleBlockState(BlockState state, Direction side, RandomSource rand, ModelData modelData, RenderType renderType) {
        int capacity = (Integer)ModelHelpers.getSafeProperty((ModelData)modelData, BlockDarkTank.TANK_CAPACITY, (Object)0);
        FluidStack fluidStack = (FluidStack)ModelHelpers.getSafeProperty((ModelData)modelData, BlockDarkTank.TANK_FLUID, (Object)FluidStack.EMPTY);
        return new ModelDarkTankBaked(this.baseModel, capacity, fluidStack, state, side, rand, modelData, renderType);
    }

    public BakedModel handleItemState(ItemStack itemStack, Level world, LivingEntity entity) {
        IFluidHandlerItemCapacity fluidHandler = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack).orElse(null);
        if (!itemStack.isEmpty() && fluidHandler != null) {
            int capacity = fluidHandler.getCapacity();
            FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
            return new ModelDarkTankBaked(this.baseModel, capacity, fluidStack, itemStack, world, entity);
        }
        return new ModelDarkTankBaked(this.baseModel, 0, null, itemStack, world, entity);
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, boolean flowing, Direction side) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        return (TextureAtlasSprite)RenderHelpers.TEXTURE_GETTER.apply((Object)(flowing && side != Direction.UP && side != Direction.DOWN ? renderProperties.getFlowingTexture(fluid) : renderProperties.getStillTexture(fluid)));
    }

    protected List<BakedQuad> getFluidQuads(FluidStack fluidStack, int capacity, boolean flowing) {
        float height = Math.min(0.99f, (float)fluidStack.getAmount() / (float)capacity) / 1.01f;
        ArrayList quads = Lists.newArrayList();
        block8: for (Direction side : Direction.values()) {
            TextureAtlasSprite texture = ModelDarkTankBaked.getFluidIcon(fluidStack, flowing, side);
            int color = RenderHelpers.getFluidBakedQuadColor((FluidStack)fluidStack);
            if (side == Direction.UP) {
                ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)0.13f, (float)0.87f, (float)0.13f, (float)0.87f, (float)height, (TextureAtlasSprite)texture, (Direction)side, (int)ROTATION_FIX[side.ordinal()], (boolean)true, (int)color, (float[][])ROTATION_UV);
                continue;
            }
            if (side == Direction.DOWN) {
                ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)0.13f, (float)0.87f, (float)0.13f, (float)0.87f, (float)0.95f, (TextureAtlasSprite)texture, (Direction)side, (int)ROTATION_FIX[side.ordinal()], (boolean)true, (int)color, (float[][])ROTATION_UV);
                continue;
            }
            float width = 0.87f;
            float x1 = 0.13f;
            float x2 = width;
            float z1 = 0.01f;
            float z2 = height;
            if (side == Direction.EAST || side == Direction.SOUTH) {
                z1 = 0.99f - height;
                z2 = 0.99f;
            }
            if (side == Direction.EAST || side == Direction.WEST) {
                float tmp1 = x1;
                float tmp2 = x2;
                x1 = z1;
                x2 = z2;
                z1 = tmp1;
                z2 = tmp2;
            }
            switch (side) {
                case DOWN: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}});
                    continue block8;
                }
                case UP: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}});
                    continue block8;
                }
                case NORTH: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x2, (float)x1, (float)z2, (float)z1, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, 0.0f}, {1.0f, height}, {0.0f, height}, {0.0f, 0.0f}});
                    continue block8;
                }
                case SOUTH: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, 0.0f}, {1.0f, height}, {0.0f, height}, {0.0f, 0.0f}});
                    continue block8;
                }
                case WEST: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)0.87f, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, height}, {0.0f, height}, {0.0f, 0.0f}, {1.0f, 0.0f}});
                    continue block8;
                }
                case EAST: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, height}, {0.0f, height}});
                }
            }
        }
        return quads;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.baseModel.getParticleIcon();
    }

    public boolean usesBlockLight() {
        return true;
    }

    public ItemTransforms getTransforms() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.translucent()});
    }
}

