/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.evilcraft.RegistryEntries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class EntityRedstoneGrenade
extends ThrowableProjectile
implements ItemSupplier {
    public EntityRedstoneGrenade(Level world, LivingEntity entity) {
        super((EntityType)RegistryEntries.ENTITY_REDSTONE_GRENADE.get(), entity, world);
    }

    public EntityRedstoneGrenade(EntityType<? extends EntityRedstoneGrenade> type, Level world) {
        super(type, world);
    }

    protected void onHit(HitResult pos) {
        if (pos.getType() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)pos).getBlockPos();
            if (this.level().isEmptyBlock(blockPos.relative(((BlockHitResult)pos).getDirection()))) {
                this.level().setBlockAndUpdate(blockPos.offset(((BlockHitResult)pos).getDirection().getNormal()), ((Block)RegistryEntries.BLOCK_INVISIBLE_REDSTONE.get()).defaultBlockState());
                if (this.level().isClientSide()) {
                    Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, false, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, 1.0, 0.0, 0.0);
                }
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public ItemStack getItem() {
        return new ItemStack(RegistryEntries.ITEM_REDSTONE_GRENADE);
    }
}

