/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;

public class RenderOverlayEventHook {
    private static final int WIDTH = 5;
    private static final int HEIGHT = 51;
    protected static final ResourceLocation BLOOD_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/overlay.png");
    private int filledHeight = -1;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderOverlayEvent(RenderGuiEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (GeneralConfig.bloodGuiOverlay) {
            if (this.filledHeight < 0 || WorldHelpers.efficientTick((Level)player.level(), (int)50, (int[])new int[0])) {
                Wrapper<Integer> amount = new Wrapper<Integer>(0);
                Wrapper<Integer> capacity = new Wrapper<Integer>(1);
                PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator((Player)player);
                while (it.hasNext()) {
                    ItemStack itemStack = it.next();
                    IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
                    if (itemStack.isEmpty() || fluidHandler == null) continue;
                    FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
                    if (!fluidStack.isEmpty() && BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) {
                        amount.set(amount.get() + fluidStack.getAmount());
                    }
                    if (!fluidStack.isEmpty() && !BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) continue;
                    capacity.set(capacity.get() + FluidHelpers.getCapacity((IFluidHandler)fluidHandler));
                }
                this.filledHeight = (int)Math.floor(51.0f * ((float)amount.get().intValue() / (float)capacity.get().intValue()));
            }
            if (this.filledHeight > 0) {
                OverlayPosition overlayPosition = OverlayPosition.values()[Mth.clamp((int)GeneralConfig.bloodGuiOverlayPosition, (int)0, (int)(OverlayPosition.values().length - 1))];
                Window resolution = Minecraft.getInstance().getWindow();
                int x = overlayPosition.getX(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetX;
                int y = overlayPosition.getY(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetY;
                event.getGuiGraphics().pose().pushPose();
                GlStateManager._enableBlend();
                GlStateManager._blendFunc((int)770, (int)771);
                RenderHelpers.bindTexture((ResourceLocation)BLOOD_OVERLAY);
                event.getGuiGraphics().blit(BLOOD_OVERLAY, x, y, 0, 0, 5, 51);
                event.getGuiGraphics().blit(BLOOD_OVERLAY, x, y + (51 - this.filledHeight), 5, 51 - this.filledHeight, 5, this.filledHeight);
                GlStateManager._disableBlend();
                event.getGuiGraphics().pose().popPose();
            }
        }
    }

    public static enum OverlayPosition {
        NE{

            @Override
            public int getX(Window resolution, int width, int height) {
                return resolution.getGuiScaledWidth() - width;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return 0;
            }
        }
        ,
        SE{

            @Override
            public int getX(Window resolution, int width, int height) {
                return resolution.getGuiScaledWidth() - width;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return resolution.getGuiScaledHeight() - height;
            }
        }
        ,
        SW{

            @Override
            public int getX(Window resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return resolution.getGuiScaledHeight() - height;
            }
        }
        ,
        NW{

            @Override
            public int getX(Window resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return 0;
            }
        };


        public abstract int getX(Window var1, int var2, int var3);

        public abstract int getY(Window var1, int var2, int var3);
    }
}

