/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public abstract class ItemAbstractGrenade
extends Item {
    protected ItemAbstractGrenade(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!world.isClientSide()) {
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.MASTER, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
            ThrowableProjectile entity = this.getThrowableEntity(itemStack, world, player);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            world.addFreshEntity((Entity)entity);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    protected abstract ThrowableProjectile getThrowableEntity(ItemStack var1, Level var2, Player var3);
}

