/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemPowerableHelpers {
    public static int getPower(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(RegistryEntries.COMPONENT_POWER, (Object)0);
    }

    public static void setPower(ItemStack itemStack, int power) {
        itemStack.set(RegistryEntries.COMPONENT_POWER, (Object)power);
    }

    public static boolean onPowerableItemItemRightClick(ItemStack itemStack, Level world, Player player, int powerLevels, boolean onSneak) {
        if (onSneak == player.isCrouching()) {
            if (!world.isClientSide()) {
                int newPower = (ItemPowerableHelpers.getPower(itemStack) + 1) % powerLevels;
                ItemPowerableHelpers.setPower(itemStack, newPower);
                player.displayClientMessage((Component)Component.translatable((String)"item.evilcraft.powerable.set_power", (Object[])new Object[]{newPower}).withStyle(ChatFormatting.DARK_PURPLE), true);
            }
            return true;
        }
        return false;
    }

    public static void addPreInformation(ItemStack itemStack, List<Component> lines) {
        L10NHelpers.addOptionalInfo(lines, (String)"item.evilcraft.powerable");
    }

    public static void addPostInformation(ItemStack itemStack, List<Component> lines) {
        lines.add((Component)Component.translatable((String)"item.evilcraft.powerable.info.power", (Object[])new Object[]{ItemPowerableHelpers.getPower(itemStack)}).withStyle(ChatFormatting.BOLD));
    }
}

