/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;

public class ItemPromise
extends Item {
    public static final Upgrades.Upgrade[] UPGRADES = new Upgrades.Upgrade[]{Upgrades.UPGRADE_TIER1, Upgrades.UPGRADE_TIER2, Upgrades.UPGRADE_TIER3, Upgrades.UPGRADE_SPEED, Upgrades.UPGRADE_EFFICIENCY};
    public static final Map<Upgrades.Upgrade, Integer> MAIN_COLORS = Maps.newHashMap();
    public static final Map<Upgrades.Upgrade, Integer> SECONDARY_COLORS = Maps.newHashMap();
    private final Upgrades.Upgrade upgrade;

    public ItemPromise(Item.Properties properties, Upgrades.Upgrade upgrade) {
        super(properties);
        this.upgrade = upgrade;
    }

    public int getMaxStackSize(ItemStack itemStack) {
        if (this.upgrade.getTier() > 0) {
            return 1;
        }
        return super.getMaxStackSize(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        if (MinecraftHelpers.isShifted()) {
            list.add((Component)Component.translatable((String)"item.evilcraft.promise.use_in").withStyle(ChatFormatting.DARK_GREEN));
            for (BlockConfig upgradable : this.getUpgrade(itemStack).getUpgradables()) {
                list.add((Component)Component.translatable((String)upgradable.getTranslationKey()).withStyle(ChatFormatting.ITALIC));
            }
        }
    }

    public Upgrades.Upgrade getUpgrade(ItemStack itemStack) {
        return this.upgrade;
    }

    public static Item getItem(int tier) {
        if (tier == 1) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER1);
        }
        if (tier == 2) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER2);
        }
        if (tier == 3) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER3);
        }
        throw new IllegalStateException("Could not find an item for tier " + tier);
    }

    public static Item getItem(Upgrades.Upgrade upgrade) {
        if (upgrade == Upgrades.UPGRADE_TIER1) {
            return (Item)RegistryEntries.ITEM_PROMISE_TIER_1.get();
        }
        if (upgrade == Upgrades.UPGRADE_TIER2) {
            return (Item)RegistryEntries.ITEM_PROMISE_TIER_2.get();
        }
        if (upgrade == Upgrades.UPGRADE_TIER3) {
            return (Item)RegistryEntries.ITEM_PROMISE_TIER_3.get();
        }
        if (upgrade == Upgrades.UPGRADE_SPEED) {
            return (Item)RegistryEntries.ITEM_PROMISE_SPEED.get();
        }
        if (upgrade == Upgrades.UPGRADE_EFFICIENCY) {
            return (Item)RegistryEntries.ITEM_PROMISE_EFFICIENCY.get();
        }
        throw new IllegalStateException("Could not find an item for " + String.valueOf(upgrade));
    }

    public boolean isTierUpgrade(ItemStack itemStack) {
        return !itemStack.isEmpty() && this.upgrade.getTier() > 0;
    }

    static {
        MAIN_COLORS.put(Upgrades.UPGRADE_TIER1, Helpers.RGBAToInt((int)220, (int)220, (int)220, (int)255));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_TIER1, Helpers.RGBAToInt((int)255, (int)255, (int)255, (int)255));
        MAIN_COLORS.put(Upgrades.UPGRADE_TIER2, Helpers.RGBAToInt((int)234, (int)238, (int)87, (int)255));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_TIER2, Helpers.RGBAToInt((int)230, (int)230, (int)160, (int)255));
        MAIN_COLORS.put(Upgrades.UPGRADE_TIER3, Helpers.RGBAToInt((int)51, (int)235, (int)203, (int)255));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_TIER3, Helpers.RGBAToInt((int)150, (int)250, (int)200, (int)255));
        MAIN_COLORS.put(Upgrades.UPGRADE_SPEED, Helpers.RGBAToInt((int)200, (int)90, (int)80, (int)255));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_SPEED, Helpers.RGBAToInt((int)240, (int)120, (int)110, (int)255));
        MAIN_COLORS.put(Upgrades.UPGRADE_EFFICIENCY, Helpers.RGBAToInt((int)80, (int)70, (int)200, (int)255));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_EFFICIENCY, Helpers.RGBAToInt((int)120, (int)120, (int)210, (int)255));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            Upgrades.Upgrade upgrade = ((ItemPromise)itemStack.getItem()).getUpgrade(itemStack);
            return renderPass == 0 ? SECONDARY_COLORS.get(upgrade) : MAIN_COLORS.get(upgrade);
        }
    }
}

