/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.mojang.authlib.GameProfile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.item.ItemWerewolfFleshConfig;

public class ItemWerewolfFlesh
extends Item {
    private static final int POISON_DURATION = 10;
    private static final int POWER_DURATION = 60;
    private static final int POWER_DURATION_BONUS = 240;
    private final boolean humanoid;
    private boolean power = false;
    public static final int MINECRAFT_DAY = 24000;

    public ItemWerewolfFlesh(Item.Properties properties, boolean humanoid) {
        super(properties.food(new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().build()));
        this.humanoid = humanoid;
        if (this.humanoid) {
            NeoForge.EVENT_BUS.addListener(this::dropHumanoidFleshEvent);
        }
    }

    public static boolean isDay(Level world) {
        return world.getDayTime() % 24000L < 12000L;
    }

    private boolean isPower(Level world) {
        return world == null ? this.power : (this.power = !ItemWerewolfFlesh.isDay(world));
    }

    public boolean isFoil(ItemStack itemStack) {
        return this.isPower(null);
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity player, int par4, boolean par5) {
        this.isPower(world);
    }

    private int getPowerDuration(ItemStack itemStack) {
        if (this.isHumanFlesh(itemStack)) {
            return 60;
        }
        return 240;
    }

    private boolean isHumanFlesh(ItemStack itemStack) {
        return this.humanoid;
    }

    private boolean isOwnCanibal(ItemStack itemStack, Player player) {
        ResolvableProfile resolvableProfile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
        if (resolvableProfile != null) {
            GameProfile profile = resolvableProfile.gameProfile();
            return player.getGameProfile().equals((Object)profile);
        }
        return false;
    }

    public ItemStack finishUsingItem(ItemStack itemStack, @Nullable Level world, LivingEntity entity) {
        if (world != null && entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, itemStack);
            }
            if (this.isOwnCanibal(itemStack, player)) {
                if (!world.isClientSide()) {
                    player.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 1));
                    player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, this.getPowerDuration(itemStack) * 20, 1));
                }
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.WOLF_HURT, SoundSource.HOSTILE, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
            } else if (this.isPower(world)) {
                int foodLevel = this.getFoodProperties(itemStack, entity).nutrition();
                float saturationLevel = this.getFoodProperties(itemStack, entity).saturation();
                player.getFoodData().eat(foodLevel, saturationLevel);
                player.getFoodData().addExhaustion(20.0f);
                if (!world.isClientSide()) {
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, this.getPowerDuration(itemStack) * 20, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, this.getPowerDuration(itemStack) * 20, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP, this.getPowerDuration(itemStack) * 20, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, this.getPowerDuration(itemStack) * 20, 2));
                }
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.WOLF_HOWL, SoundSource.HOSTILE, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
            } else {
                if (!world.isClientSide()) {
                    player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 1));
                }
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.WOLF_HURT, SoundSource.HOSTILE, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
            }
            entity.eat(world, itemStack);
        }
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        if (this.isHumanFlesh(itemStack)) {
            GameProfile profile;
            Object player = String.valueOf(ChatFormatting.ITALIC) + "None";
            ResolvableProfile resolvableProfile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
            if (resolvableProfile != null && (profile = resolvableProfile.gameProfile()) != null && !profile.getProperties().isEmpty()) {
                player = profile.getName();
            }
            list.add((Component)Component.literal((String)"Player: ").withStyle(ChatFormatting.WHITE).append((String)player));
        }
    }

    public void dropHumanoidFleshEvent(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayer && !event.getEntity().level().isClientSide() && event.getEntity().level().random.nextInt(ItemWerewolfFleshConfig.humanoidFleshDropChance) == 0) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ItemStack itemStack = new ItemStack((ItemLike)this);
            itemStack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(player.getGameProfile()));
            double x = player.getX();
            double y = player.getY();
            double z = player.getZ();
            ItemEntity entity = new ItemEntity(player.level(), x, y, z, itemStack);
            player.level().addFreshEntity((Entity)entity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            if (((ItemWerewolfFlesh)itemStack.getItem()).isHumanFlesh(itemStack)) {
                return Helpers.RGBAToInt((int)255, (int)200, (int)180, (int)255);
            }
            return -1;
        }
    }
}

