/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemWerewolfFlesh;

public class ItemWerewolfFleshConfig
extends ItemConfig {
    @ConfigurableProperty(category="item", comment="Humanoid flesh will drop in a 1/X chance.", isCommandable=true)
    public static int humanoidFleshDropChance = 5;

    public ItemWerewolfFleshConfig(boolean humanoid) {
        super((ModBase)EvilCraft._instance, humanoid ? "flesh_humanoid" : "flesh_werewolf", eConfig -> new ItemWerewolfFlesh(new Item.Properties().rarity(humanoid ? Rarity.RARE : Rarity.EPIC).stacksTo(16), humanoid));
        if (MinecraftHelpers.isClientSide()) {
            EvilCraft._instance.getModEventBus().addListener(this::registerColors);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new ItemWerewolfFlesh.ItemColor(), new ItemLike[]{(ItemLike)this.getInstance()});
    }
}

