/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.BlockClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BlockDarkTank;
import org.cyclops.evilcraft.block.BlockDarkTankConfigClient;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.jetbrains.annotations.Nullable;

public class BlockDarkTankConfig
extends BlockConfigCommon<ModBaseNeoForge<?>> {
    @ConfigurablePropertyCommon(category="machine", comment="The maximum tank size visible in the creative tabs. (Make sure that you do not cross the max int size.)")
    public static int maxTankCreativeSize = 4096000;
    @ConfigurablePropertyCommon(category="machine", comment="If creative versions for all fluids should be added to the creative tab.")
    public static boolean creativeTabFluids = true;
    @ConfigurablePropertyCommon(category="item", comment="If held buckets should be autofilled when enabled.", isCommandable=true)
    public static boolean autoFillBuckets = false;

    public BlockDarkTankConfig() {
        super((IModBase)EvilCraft._instance, "dark_tank", (eConfig, properties) -> new BlockDarkTank(properties.strength(0.5f).sound(SoundType.GLASS)), (eConfig, block) -> new ItemBlockFluidContainer((Block)block, eConfig.createDefaultItemProperties()));
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    @Nullable
    public BlockClientConfig<ModBaseNeoForge<?>> constructBlockClientConfig() {
        if (((ModBaseNeoForge)this.getMod()).getModHelpers().getMinecraftHelpers().isClientSide()) {
            return new BlockDarkTankConfigClient(this);
        }
        return null;
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        NonNullList list = NonNullList.create();
        ((BlockDarkTank)this.getInstance()).fillItemCategory((NonNullList<ItemStack>)list);
        return list;
    }
}

