/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityNetherfish;

public class BlockInfestedNether
extends Block {
    private final Type type;

    public BlockInfestedNether(BlockBehaviour.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (!world.isClientSide()) {
            EntityNetherfish netherfish = new EntityNetherfish((Level)world);
            netherfish.snapTo(blockPos, 0.0f, 0.0f);
            world.addFreshEntity((Entity)netherfish);
            netherfish.spawnAnim();
        }
        super.destroy(world, blockPos, blockState);
    }

    @Nullable
    public static Type unwrapBlock(BlockState blockState) {
        if (blockState.getBlock() == Blocks.NETHERRACK) {
            return Type.NETHERRACK;
        }
        if (blockState.getBlock() == Blocks.NETHER_BRICKS) {
            return Type.NETHER_BRICKS;
        }
        if (blockState.getBlock() == Blocks.SOUL_SAND) {
            return Type.SOUL_SAND;
        }
        return null;
    }

    public static Block wrapBlock(Type type) {
        switch (type.ordinal()) {
            case 0: {
                return (Block)RegistryEntries.BLOCK_INFESTED_NETHER_NETHERRACK.get();
            }
            case 1: {
                return (Block)RegistryEntries.BLOCK_INFESTED_NETHER_NETHER_BRICK.get();
            }
            case 2: {
                return (Block)RegistryEntries.BLOCK_INFESTED_NETHER_SOUL_SAND.get();
            }
        }
        return null;
    }

    public static enum Type {
        NETHERRACK,
        NETHER_BRICKS,
        SOUL_SAND;

    }
}

