/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.purifier;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.block.BlockPurifierConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;

public class CollectPotionPurifyAction
implements IPurifierAction {
    public static final Item ALLOWED_ITEM = Items.GLASS_BOTTLE;
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return !itemStack.isEmpty() && itemStack.getItem() == ALLOWED_ITEM;
    }

    @Override
    public boolean canWork(BlockEntityPurifier tile) {
        if (tile.getPurifyItem().isEmpty() && !tile.getAdditionalItem().isEmpty() && tile.getAdditionalItem().getItem() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            List entities = tile.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB(Vec3.atLowerCornerOf((Vec3i)tile.getBlockPos()), Vec3.atLowerCornerOf((Vec3i)tile.getBlockPos().offset(1, 2, 1))));
            for (LivingEntity entity : entities) {
                for (MobEffectInstance potionEffect : entity.getActiveEffects()) {
                    if (potionEffect.isAmbient()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean work(BlockEntityPurifier tile) {
        Level world = tile.getLevel();
        int tick = tile.getTick();
        if (tile.getPurifyItem().isEmpty() && !tile.getAdditionalItem().isEmpty() && tile.getAdditionalItem().getItem() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            List entities = tile.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB(Vec3.atLowerCornerOf((Vec3i)tile.getBlockPos()), Vec3.atLowerCornerOf((Vec3i)tile.getBlockPos().offset(1, 2, 1))));
            for (LivingEntity entity : entities) {
                if (entity.getActiveEffects().isEmpty()) continue;
                if (tick >= 60 && !world.isClientSide()) {
                    for (MobEffectInstance potionEffect : entity.getActiveEffects()) {
                        if (potionEffect.isAmbient()) continue;
                        entity.removeEffect(potionEffect.getEffect());
                        if (BlockPurifierConfig.maxPotionEffectDuration > 0 && potionEffect.getDuration() > BlockPurifierConfig.maxPotionEffectDuration) {
                            int remainingDuration = potionEffect.getDuration() - BlockPurifierConfig.maxPotionEffectDuration;
                            MobEffectInstance remainingEffect = new MobEffectInstance(potionEffect);
                            remainingEffect.duration = remainingDuration;
                            entity.addEffect(remainingEffect);
                            potionEffect.duration = BlockPurifierConfig.maxPotionEffectDuration;
                        }
                        ItemStack itemStack = new ItemStack((ItemLike)Items.POTION);
                        itemStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), (List)Lists.newArrayList((Object[])new MobEffectInstance[]{potionEffect}), Optional.empty()));
                        tile.setBuckets(0, 0);
                        tile.setAdditionalItem(itemStack);
                        return true;
                    }
                }
                if (!world.isClientSide()) continue;
                tile.showEffect();
            }
        }
        return false;
    }
}

