/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.evilcraft.client.key.Keys;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;

public class ContainerScreenExaltedCrafter
extends ContainerScreenExtended<ContainerExaltedCrafter> {
    private ButtonText buttonClear;
    private ButtonText buttonBalance;

    public ContainerScreenExaltedCrafter(ContainerExaltedCrafter container, Inventory playerInventory, Component title) {
        super((ContainerExtended)container, playerInventory, title);
    }

    protected int getBaseYSize() {
        return 225;
    }

    public boolean charTyped(char keyCode, int scanCode) {
        return this.handleKeyCode(keyCode, scanCode) || super.charTyped(keyCode, scanCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 256 && this.handleKeyCode(keyCode, scanCode)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean handleKeyCode(int keyCode, int scanCode) {
        InputConstants.Key inputCode = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (Keys.EXALTEDCRAFTING.isActiveAndMatches(inputCode)) {
            if (IModHelpers.get().getMinecraftClientHelpers().isShifted()) {
                this.buttonBalance.onPress();
            } else {
                this.buttonClear.onPress();
            }
            return true;
        }
        return false;
    }

    public ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/exalted_crafter_gui.png");
    }

    public void init() {
        super.init();
        this.buttonClear = (ButtonText)this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 88, this.topPos + 58, 13, 12, (Component)Component.translatable((String)"gui.exalted_crafting.clear"), (Component)Component.literal((String)"C"), this.createServerPressable("clear", button -> {}), true));
        this.buttonBalance = (ButtonText)this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 103, this.topPos + 58, 13, 12, (Component)Component.translatable((String)"gui.exalted_crafting.balance"), (Component)Component.literal((String)"B"), this.createServerPressable("balance", button -> {}), true));
        this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 36, this.topPos + 70, 40, 12, (Component)Component.translatable((String)"gui.exalted_crafting.toggle_return"), (Component)Component.literal((String)"..."), this.createServerPressable("toggleReturn", button -> {}), true){

            public Component getText() {
                return Component.literal((String)(((ContainerExaltedCrafter)ContainerScreenExaltedCrafter.this.container).isReturnToInnerInventory() ? "inner" : "player"));
            }
        });
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        ItemStack itemStack = ((ContainerExaltedCrafter)this.container).getItemStack((Player)this.getMinecraft().player);
        MutableComponent name = Component.translatable((String)"gui.exalted_crafting");
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            name = itemStack.getHoverName();
        }
        guiGraphics.drawString(this.font, (Component)name, 28, 6, 0x404040, false);
    }
}

