/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.cyclops.evilcraft.client.render.entity.RenderStateVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class RenderVengeanceSpirit
extends EntityRenderer<EntityVengeanceSpirit, RenderStateVengeanceSpirit> {
    private final RenderPlayerSpirit playerRenderer;
    private final Map<GameProfile, GameProfile> checkedProfiles = Maps.newHashMap();

    public RenderVengeanceSpirit(EntityRendererProvider.Context context, EntityVengeanceSpiritConfig config) {
        super(context);
        this.playerRenderer = new RenderPlayerSpirit(context);
    }

    public void render(RenderStateVengeanceSpirit renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        LivingEntityRenderer render;
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
        Mob innerEntity = renderState.spirit.getInnerEntity();
        if (innerEntity != null && renderState.spirit.isVisible() && (render = (LivingEntityRenderer)this.entityRenderDispatcher.renderers.get(innerEntity.getType())) != null && !renderState.spirit.isSwarm()) {
            PlayerRenderState innerRenderState;
            Object object = innerRenderState = renderState.spirit.isPlayer() ? this.getPlayerRenderState(renderState) : (LivingEntityRenderState)render.createRenderState();
            if (!renderState.spirit.isPlayer()) {
                render.extractRenderState((LivingEntity)innerEntity, (LivingEntityRenderState)innerRenderState, renderState.partialTick);
            }
            MultiBufferSource bufferSub = arg_0 -> this.lambda$render$0(renderState, (LivingEntityRenderState)innerRenderState, render, bufferSource, arg_0);
            try {
                PoseStack poseStackInner = new PoseStack();
                poseStackInner.last().pose().set((Matrix4fc)poseStack.last().pose());
                poseStackInner.last().normal().set((Matrix3fc)poseStack.last().normal());
                if (renderState.spirit.isPlayer()) {
                    PlayerRenderState playerRenderState = innerRenderState;
                    GameProfile gameProfile = new GameProfile(renderState.spirit.getPlayerUUID(), renderState.spirit.getPlayerName());
                    ResourceLocation resourcelocation = DefaultPlayerSkin.getDefaultTexture();
                    Minecraft minecraft = Minecraft.getInstance();
                    if (!this.checkedProfiles.containsKey(gameProfile)) {
                        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                        if (property == null) {
                            GameProfile newGameProfile = Minecraft.getInstance().getMinecraftSessionService().fetchProfile(gameProfile.getId(), true).profile();
                            this.checkedProfiles.put(gameProfile, newGameProfile);
                        }
                    } else {
                        PlayerSkin skin = minecraft.getSkinManager().getInsecureSkin(this.checkedProfiles.get(gameProfile));
                        resourcelocation = skin.texture();
                        playerRenderState.skin = skin;
                    }
                    this.playerRenderer.setPlayerTexture(resourcelocation);
                    Minecraft.getInstance().options.hideGui = true;
                    this.playerRenderer.render((LivingEntityRenderState)playerRenderState, poseStackInner, bufferSub, packedLight);
                    Minecraft.getInstance().options.hideGui = false;
                } else {
                    render.render((LivingEntityRenderState)innerRenderState, poseStackInner, bufferSub, packedLight);
                }
            }
            catch (Exception e) {
                renderState.spirit.setSwarm(true);
                renderState.spirit.setPlayerId("");
            }
        }
    }

    private PlayerRenderState getPlayerRenderState(RenderStateVengeanceSpirit renderState) {
        PlayerRenderState playerRenderState = new PlayerRenderState();
        playerRenderState.x = renderState.x;
        playerRenderState.y = renderState.y;
        playerRenderState.z = renderState.z;
        playerRenderState.ageInTicks = renderState.ageInTicks;
        playerRenderState.boundingBoxWidth = renderState.boundingBoxWidth;
        playerRenderState.boundingBoxHeight = renderState.boundingBoxHeight;
        playerRenderState.eyeHeight = renderState.eyeHeight;
        playerRenderState.distanceToCameraSq = renderState.distanceToCameraSq;
        playerRenderState.isInvisible = renderState.isInvisible;
        playerRenderState.isDiscrete = renderState.isDiscrete;
        playerRenderState.displayFireAnimation = renderState.displayFireAnimation;
        playerRenderState.passengerOffset = renderState.passengerOffset;
        playerRenderState.nameTag = renderState.nameTag;
        playerRenderState.nameTagAttachment = renderState.nameTagAttachment;
        playerRenderState.leashStates = renderState.leashStates;
        playerRenderState.partialTick = renderState.partialTick;
        return playerRenderState;
    }

    public RenderStateVengeanceSpirit createRenderState() {
        return new RenderStateVengeanceSpirit();
    }

    public void extractRenderState(EntityVengeanceSpirit entity, RenderStateVengeanceSpirit renderState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)renderState, partialTick);
        renderState.spirit = entity;
    }

    private /* synthetic */ VertexConsumer lambda$render$0(RenderStateVengeanceSpirit renderState, LivingEntityRenderState innerRenderState, LivingEntityRenderer render, MultiBufferSource bufferSource, RenderType renderType) {
        float uv = renderState.spirit.isFrozen() ? ((float)renderState.spirit.tickCount + renderState.partialTick) * 0.01f : 1.0f;
        renderType = RenderType.energySwirl((ResourceLocation)(renderState.spirit.isPlayer() ? this.playerRenderer.getTextureLocation((PlayerRenderState)innerRenderState) : render.getTextureLocation(innerRenderState)), (float)uv, (float)uv);
        return bufferSource.getBuffer(renderType);
    }

    public static class RenderPlayerSpirit
    extends LivingEntityRenderer<Mob, PlayerRenderState, PlayerModel> {
        private ResourceLocation playerTexture;

        public RenderPlayerSpirit(EntityRendererProvider.Context context) {
            super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
            this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()));
            this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
            this.addLayer((RenderLayer)new ArrowLayer((LivingEntityRenderer)this, context));
            this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet()));
        }

        public void setPlayerTexture(ResourceLocation playerTexture) {
            this.playerTexture = playerTexture;
        }

        public PlayerRenderState createRenderState() {
            return new PlayerRenderState();
        }

        public ResourceLocation getTextureLocation(PlayerRenderState renderState) {
            return this.playerTexture;
        }
    }
}

